/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.job;

import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.DateParameter;

public class PurgeJobsOperation
extends AbstractSchedulerOperation {
    public static final String NAME = "purge jobs";

    public PurgeJobsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("PURGE JOBS");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FROM", false).addParameter(new DateParameter("FromTime", SCHEDULER_DATE_FORMAT))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TO", false).addParameter(new DateParameter("ToTime", SCHEDULER_DATE_FORMAT))).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Removes all finished jobs in the current node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   from      - Removes finished jobs scheduled before the specified time (including the boundary).\n   to        - Removes finished jobs scheduled after the specified time (including the boundary).\n   at node   - Removes all finished jobs in the specified node.\n   at domain - Removes all finished jobs in all nodes of the sysplex.\n\n" + PurgeJobsOperation.getTimeFormat());
        this.syntax.setExamples("purge jobs\npurge jobs from '05-31-2013 08:31:12 PM'\npurge jobs to '05-31-2013 08:31:13 PM'\npurge jobs from '05-31-2013 08:31:12 PM' to '05-31-2013 08:31:13 PM'\npurge jobs at node Node1\npurge jobs at domain");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.getScheduler(session).purgeJobs(definition.fromTime, definition.toTime);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSchedulerOperation.AbstractPurgeDefinition {
        Definition(DSLStatement statement) throws ParsingException {
            super(PurgeJobsOperation.NAME, statement);
        }
    }
}

