/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.job;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.scheduler.job.AbstractJobOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.JobType;
import com.streamscape.sef.scheduler.RepeatingJob;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.DateParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class ListJobsOperation
extends AbstractJobOperation {
    public static final String NAME = "list jobs";

    public ListJobsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST JOBS");
        this.syntax.addModifier((AbstractModifier)new ChoiceModifier(false).addPossibleValues("SINGLE", "REPEATING").setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("LIKE", false).addParameter((SyntaxParameter)new StringParameter("Pattern").setName("LikePattern")));
        this.syntax.addModifier((AbstractModifier)new Modifier("FROM", false).addParameter(new DateParameter("FromTime", SCHEDULER_DATE_FORMAT)));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TO", false).addParameter(new DateParameter("ToTime", SCHEDULER_DATE_FORMAT))).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Returns a list of jobs in the current node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   like '<Pattern>'   - Returns a list of jobs whose name matches the specified pattern.\n                        In addition to the standard Regexp, the symbol % is used as alias for .* rule.\n   from '<FromTime>'  - Returns a list of jobs scheduled for execution after the specified time (including the boundary).\n   to '<ToTime>'      - Returns a list of jobs scheduled for execution before the specified time (including the boundary).\n   at node <NodeName> - Returns a list of jobs in the specified node.\n   at domain          - Returns a list of jobs in the sysplex.\n\n" + ListJobsOperation.getTimeFormat());
        this.syntax.setExamples("list jobs\nlist jobs single\nlist jobs repeating\nlist jobs like 'Te.*'\nlist jobs like 'Te%'\nlist jobs at node Node1\nlist jobs at domain\nlist jobs from '05-31-2013 08:31:12 PM' to '06-30-2013 08:31:12 PM'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("SINGLE") ? JobType.SINGLE : (statement.existsModifier("REPEATING") ? JobType.REPEATING : null), statement.existsParameter("LikePattern") ? statement.getParameter("LikePattern").getValue() : null, statement.existsParameter("FromTime") ? ListJobsOperation.parseDate(statement.getParameter("FromTime").getValue()) : null, statement.existsParameter("ToTime") ? ListJobsOperation.parseDate(statement.getParameter("ToTime").getValue()) : null, AtNodeOrAtDomainModifier.getValue(statement));
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ListJobsOperation.createResultDescriptor(definition.jobType));
        this.getScheduler(session).getJobs(definition.fromTime, definition.toTime).stream().filter(this.getPredicate(definition)).forEach(job -> ListJobsOperation.add(result, this.getParameters((ScheduledJob)job, definition.jobType)));
        return new SLResponse(result);
    }

    private Predicate<ScheduledJob> getPredicate(Definition definition) throws Exception {
        if (definition.pattern != null) {
            Pattern pattern = ListJobsOperation.compilePattern(definition.pattern.replace("%", ".*"));
            return job -> this.getDefaultPredicate(definition).test((ScheduledJob)job) && pattern.matcher(job.getName()).matches();
        }
        return this.getDefaultPredicate(definition);
    }

    private Predicate<ScheduledJob> getDefaultPredicate(Definition definition) {
        return job -> definition.jobType == null || job.getType() == definition.jobType;
    }

    private Object[] getParameters(ScheduledJob job, JobType jobType) {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(((RuntimeContext)this.callable).getName(), job.getType().toString(), job.getName(), job.getOwner(), ListJobsOperation.skipNull(job.getTaskListName()), ListJobsOperation.formatDate(job.getStartTime())));
        if (ListJobsOperation.isRepeating(jobType)) {
            RepeatingJob repeatingJob = (RepeatingJob)job;
            result.add(ListJobsOperation.formatInterval(repeatingJob.getRepeatInterval(), repeatingJob.getRepeatIntervalUnit()));
            result.add(ListJobsOperation.formatRepeatCount(repeatingJob.getRepeatCount()));
        }
        result.add(job.getState().toString());
        TaskList taskList = job.getTaskList();
        result.add((String)((Object)Boolean.valueOf(taskList != null && taskList.getExecution() != null)));
        return result.toArray();
    }

    private static RowMetaData createResultDescriptor(JobType jobType) {
        RowMetaData result = new RowMetaData();
        ListJobsOperation.addColumn(result, "Node");
        ListJobsOperation.addColumn(result, "Type");
        ListJobsOperation.addColumn(result, "Name");
        ListJobsOperation.addColumn(result, "Owner");
        ListJobsOperation.addColumn(result, "Task List");
        ListJobsOperation.addColumn(result, "Start Time");
        if (ListJobsOperation.isRepeating(jobType)) {
            ListJobsOperation.addColumn(result, "Repeat Interval");
            ListJobsOperation.addColumn(result, "Repeat Count");
        }
        ListJobsOperation.addColumn(result, "State");
        ListJobsOperation.addColumn(result, "Running");
        return result;
    }

    private static boolean isRepeating(JobType jobType) {
        return jobType == JobType.REPEATING;
    }

    static class Definition
    extends AbstractSLStatement {
        private JobType jobType;
        private String pattern;
        private Date fromTime;
        private Date toTime;
        private String nodeName;

        public Definition(JobType jobType, String pattern, Date fromTime, Date toTime, String nodeName) {
            super(ListJobsOperation.NAME);
            this.jobType = jobType;
            this.pattern = pattern;
            this.fromTime = fromTime;
            this.toTime = toTime;
            this.nodeName = nodeName;
        }
    }
}

