/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.job;

import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.scheduler.job.AbstractJobOperation;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.RepeatingJob;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeJobOperation
extends AbstractJobOperation {
    public static final String NAME = "describe job";

    public DescribeJobOperation() {
        this.createDSLSyntax(NAME);
        this.setAction("DESCRIBE", null);
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("DESCRIPTION"))).addModifier(new Modifier("NOTIFY"))).addModifier(new Modifier("METASET")));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier(false));
        this.syntax.setDescription("Shows information about the specified Job in the current node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   description        - Shows the Job description.\n   notify             - Shows parameters of Email Notification feature.\n   at node <NodeName> - Shows information about the specified Job in the specified node.");
        this.syntax.setExamples("describe job TestJob\ndescribe job TestJob at node Node1\ndescribe job TestJob description\ndescribe job TestJob description at node TestNode1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement, statement.existsModifier("DESCRIPTION"), statement.existsModifier("NOTIFY"), statement.existsModifier("METASET"), AtNodeOrAtDomainModifier.getValue(statement));
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        RowSet rowSet;
        Definition definition = (Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        String jobName = DescribeJobOperation.getJobName(definition.statement);
        if (definition.description) {
            rowSet = new RowSet(DescribeJobOperation.createResultDescriptorDescription());
            DescribeJobOperation.addValues(rowSet, DescribeJobOperation.skipNull(this.lookupJob(scheduler, jobName).getDescription()));
        } else if (definition.notify) {
            ScheduledJob job = this.lookupJob(scheduler, jobName);
            rowSet = new RowSet(DescribeJobOperation.createResultDescriptor("Property", "Value", "Resolved Value"));
            DescribeJobOperation.addValues(rowSet, "Notification Enabled", job.isNotify(), "");
            DescribeJobOperation.addValues(rowSet, new Object[]{"Notification Level", job.getNotifyLevel(), ""});
            DescribeJobOperation.addValues(rowSet, "Notification To", DescribeJobOperation.skipNull(job.getNotifyTo()), DescribeJobOperation.skipNull(job.getNotifyToResolved()));
            DescribeJobOperation.addValues(rowSet, "Notification Subject", DescribeJobOperation.skipNull(job.getNotifySubject()), DescribeJobOperation.skipNull(job.getNotifySubjectResolved()));
            DescribeJobOperation.addValues(rowSet, "Notification Body", DescribeJobOperation.skipNull(job.getNotifyBody()), DescribeJobOperation.skipNull(job.getNotifyBodyResolved()));
        } else if (definition.metaset) {
            ScheduledJob job = this.lookupJob(scheduler, jobName);
            Metaset metaset = job.getExecutionMetaset();
            if (metaset == null) {
                throw new Exception("Metaset not attached.");
            }
            rowSet = new RowSet(DescribeJobOperation.createResultDescriptor("Key", "Type", "Value"));
            for (String key : metaset.listKeys()) {
                Object value = metaset.get(key);
                DescribeJobOperation.addValues(rowSet, new Object[]{key, PropertyType.resolveType(value), value});
            }
        } else {
            ScheduledJob job = this.lookupJob(scheduler, jobName);
            rowSet = new RowSet(DescribeJobOperation.createSimpleResultDescriptor());
            DescribeJobOperation.addValues(rowSet, "Node", node.getName());
            DescribeJobOperation.addValues(rowSet, new Object[]{"Type", job.getType()});
            DescribeJobOperation.addValues(rowSet, "Name", job.getName());
            DescribeJobOperation.addValues(rowSet, "Author", job.getAuthor());
            DescribeJobOperation.addValues(rowSet, "Created On", DescribeJobOperation.formatDate(job.getCreationTime()));
            DescribeJobOperation.addValues(rowSet, "Owner", job.getOwner());
            DescribeJobOperation.addValues(rowSet, "Last Modified On", DescribeJobOperation.formatDate(job.getLastUpdateTime()));
            DescribeJobOperation.addValues(rowSet, "Task List", DescribeJobOperation.skipNull(job.getTaskListName()));
            DescribeJobOperation.addValues(rowSet, "Start Time", DescribeJobOperation.formatDate(job.getStartTime()));
            if (job instanceof RepeatingJob) {
                RepeatingJob repeatingJob = (RepeatingJob)job;
                DescribeJobOperation.addValues(rowSet, "Repeat Interval", DescribeJobOperation.formatInterval(repeatingJob.getRepeatInterval(), repeatingJob.getRepeatIntervalUnit()));
                DescribeJobOperation.addValues(rowSet, "Repeat Count", DescribeJobOperation.formatRepeatCount(repeatingJob.getRepeatCount()));
                if (!repeatingJob.getExclusionWindows().isEmpty()) {
                    DescribeJobOperation.addValues(rowSet, "Exclusion Windows", repeatingJob.getExclusionWindows().stream().map(w -> DescribeJobOperation.formatDate(w.getStartTime()) + " - " + DescribeJobOperation.formatDate(w.getEndTime())).collect(Collectors.toList()));
                }
                if (!repeatingJob.getExclusionDaysOfWeek().isEmpty()) {
                    DescribeJobOperation.addValues(rowSet, "Exclusion Days Of Week", repeatingJob.getExclusionDaysOfWeek());
                }
                this.addLastCommonFields(job, rowSet);
                this.addRunningState(job, rowSet);
                DescribeJobOperation.addValues(rowSet, "Last Execution Time", DescribeJobOperation.formatExecTime(repeatingJob.getLastExecutionTime()));
                if (job.getState() != JobState.DISABLED) {
                    DescribeJobOperation.addValues(rowSet, "Next Execution Time", DescribeJobOperation.formatExecTime(repeatingJob.getNextExecutionTime()));
                    DescribeJobOperation.addValues(rowSet, "Remaining Repeat Count", DescribeJobOperation.formatRepeatCount(repeatingJob.getRemainingRepeatCount()));
                }
            } else {
                this.addLastCommonFields(job, rowSet);
                this.addRunningState(job, rowSet);
            }
        }
        return new SLResponse(rowSet);
    }

    private void addLastCommonFields(ScheduledJob job, RowSet rowSet) {
        DescribeJobOperation.addValues(rowSet, "Notification Enabled", job.isNotify());
        DescribeJobOperation.addValues(rowSet, new Object[]{"Notification Level", job.getNotifyLevel()});
        DescribeJobOperation.addValues(rowSet, "Notification To", DescribeJobOperation.skipNull(job.getNotifyTo()));
        DescribeJobOperation.addValues(rowSet, "Notification Subject", DescribeJobOperation.skipNull(job.getNotifySubject()));
        DescribeJobOperation.addValues(rowSet, "Notification Body", DescribeJobOperation.skipNull(job.getNotifyBody()));
        DescribeJobOperation.addValues(rowSet, "Metaset", job.hasExecutionMetaset());
        DescribeJobOperation.addValues(rowSet, "Events", this.listEvents(job));
        DescribeJobOperation.addValues(rowSet, "State", job.getState().toString());
    }

    private List<String> listEvents(ScheduledJob job) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("advisory.Scheduler");
        result.add("exception.Scheduler");
        if (job.isNotify()) {
            result.add("event.Scheduler.Email");
        }
        if (job.getTaskList() != null) {
            result.addAll(this.listEvents(job.getTaskList()).stream().filter(eventId -> !result.contains(eventId)).collect(Collectors.toList()));
        }
        return result;
    }

    private void addRunningState(ScheduledJob job, RowSet rowSet) {
        TaskList taskList = job.getTaskList();
        DescribeJobOperation.addValues(rowSet, "Running", taskList != null && taskList.getExecution() != null);
    }

    private static RowMetaData createResultDescriptorTriggers() {
        RowMetaData result = new RowMetaData();
        DescribeJobOperation.addColumn(result, "Name");
        DescribeJobOperation.addColumn(result, "Job");
        DescribeJobOperation.addColumn(result, "Task");
        DescribeJobOperation.addColumn(result, "Enabled");
        return result;
    }

    static class Definition
    extends AbstractSchedulerOperation.Definition {
        private boolean description;
        private boolean notify;
        private boolean metaset;
        private String nodeName;

        Definition(DSLStatement statement, boolean description, boolean notify, boolean metaset, String nodeName) {
            super(DescribeJobOperation.NAME, statement);
            this.description = description;
            this.notify = notify;
            this.metaset = metaset;
            this.nodeName = nodeName;
        }
    }
}

