/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.job;

import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.scheduler.job.AbstractJobOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.AbstractExecutableObject;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class CopyJobOperation
extends AbstractJobOperation {
    public static final String NAME = "copy job";

    public CopyJobOperation() {
        this.createDSLSyntax(NAME);
        this.setAction("COPY", JobState.ENABLED, JobState.DISABLED, JobState.FINISHED);
        this.syntax.addModifier((AbstractModifier)((CompoundModifier)new AtNodeOrAtDomainModifier().setRequired(true)).setSyntaxHintSpace());
        this.addNameModifier();
        this.syntax.addModifier((AbstractModifier)new Modifier("WITH TASKLIST", false).addParameter((SyntaxParameter)new IdentifierParameter("NewListName").setRequired(false)));
        this.addEnableModifier();
        this.syntax.setDescription("Copies the specified Job to other nodes.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   at node        - Copies the specified Job to the specified node.\n   at domain      - Copies the specified Job to all nodes of Sysplex.\n\nOptional parameters:\n\n   name           - New name of the Job.\n   with tasklist  - Copies the specified Job with its Task List if exists.\n      NewListName - New name of the Task List.\n   enable         - Enables the Job (and its Task List if exists) after copying.");
        this.syntax.setExamples("copy job TestJob at node TestNode\ncopy job TestJob at domain");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement, AtNodeOrAtDomainModifier.getValue(statement), statement.existsParameter("NewName") ? statement.getParameter("NewName").getValue() : null, statement.existsModifier("WITH TASKLIST"), statement.existsParameter("NewName") ? statement.getParameter("NewListName").getValue() : null, statement.existsModifier("ENABLE"));
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.job == null) {
            Scheduler scheduler = this.getScheduler(session);
            definition.job = this.lookupJob(scheduler, definition.statement);
            if (definition.withTaskList && definition.job.getTaskList() != null) {
                definition.taskList = CopyJobOperation.lookupTaskList(scheduler, definition.job.getTaskListName());
            }
        }
        return this.invoke(definition.nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        String jobName;
        Definition definition = (Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        String string = jobName = definition.newJobName != null ? definition.newJobName : definition.job.getName();
        if (scheduler.existsJob(jobName)) {
            throw new Exception("Job '" + jobName + "' already exists.");
        }
        AbstractExecutableObject taskList = null;
        if (definition.taskList != null) {
            String listName;
            String string2 = listName = definition.newListName != null ? definition.newListName : definition.taskList.getName();
            if (scheduler.existsTaskList(listName)) {
                throw new Exception("Task list '" + listName + "' already exists.");
            }
            taskList = scheduler.createTaskList(listName, definition.taskList);
            if (definition.enable) {
                scheduler.enableTaskList(listName);
            }
        }
        ScheduledJob job = scheduler.createJob(jobName, definition.job);
        if (taskList != null) {
            scheduler.setJobTaskList(jobName, taskList.getName());
        }
        if (definition.enable) {
            scheduler.enableJob(jobName);
        }
        return new SLResponse();
    }

    static class Definition
    extends AbstractSchedulerOperation.Definition {
        private String nodeName;
        private String newJobName;
        private boolean withTaskList;
        private String newListName;
        private boolean enable;
        private ScheduledJob job;
        private TaskList taskList;

        Definition(DSLStatement statement, String nodeName, String newJobName, boolean withTaskList, String newListName, boolean enable) {
            super(CopyJobOperation.NAME, statement);
            this.nodeName = nodeName;
            this.newJobName = newJobName;
            this.withTaskList = withTaskList;
            this.newListName = newListName;
            this.enable = enable;
        }
    }
}

