/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.job;

import com.streamscape.runtime.mf.operation.scheduler.job.AbstractAlterJobOperation;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.JobType;
import com.streamscape.sef.scheduler.RepeatingJob;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.DateParameter;

public class AlterJobRepeatingOperation
extends AbstractAlterJobOperation {
    public static final String NAME = "alter job repeating";

    public AlterJobRepeatingOperation() {
        super(NAME, JobType.REPEATING, " REPEATING", "Alters the specified repeating Job.");
        this.syntax.setExamples("alter job repeating TestJob\nalter job repeating TestJob name TestJob1\nalter job repeating TestJob set tasklist TestList set start time '05-31-2013 08:31:12 PM'\nalter job repeating TestJob clear tasklist clear start time\nalter job repeating TestJob interval 10 seconds repeat count 10\nalter job repeating TestJob description 'Test job.'\nalter job repeating TestJob attach metaset @m1");
    }

    @Override
    protected void addStartTimeModifier() {
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("CLEAR START TIME"))).addModifier((AbstractModifier)new Modifier("SET START TIME").addParameter(new DateParameter("StartTime", SCHEDULER_DATE_FORMAT))));
    }

    @Override
    protected void addMainModifiers() {
        this.addRepeatingModifiers();
    }

    @Override
    protected void addOtherModifiers() {
        this.addClearExclusionWindowsModifier();
        this.addExclusionWindowsModifier("remove");
        this.addExclusionWindowsModifier("add");
        this.addClearExclusionDaysOfWeekModifier();
        this.addExclusionDaysOfWeekModifier("remove");
        this.addExclusionDaysOfWeekModifier("add");
    }

    protected void addClearExclusionWindowsModifier() {
        this.syntax.addModifier(new Modifier("CLEAR EXCLUSION WINDOWS", false));
    }

    protected void addClearExclusionDaysOfWeekModifier() {
        this.syntax.addModifier(new Modifier("CLEAR EXCLUSION DAYS OF WEEK", false));
    }

    @Override
    protected String getMainParametersDescription(String indent) {
        return "   name       " + indent + " - New name of the Job.\n   tasklist   " + indent + " - Task list that is executed by the Job.\n" + indent + "                    set   - Sets the specified Task List to the Job.\n" + indent + "                    clear - Removes an existing Task List from the Job.\n";
    }

    @Override
    protected String getTimeParameterDescription(String indent) {
        return "   start time" + indent + "  - Time when the Job will execute the associated Task List.\n" + indent + "                    set   - Sets the specified start time to the Job.\n" + indent + "                    clear - Removes an existing start time from the Job.\n";
    }

    @Override
    protected String getOtherParametersDescription(String indent) {
        return "\n   exclusion windows      - List of time intervals excluded from execution schedule of the associated Task List.\n                               add    - Adds a new exclusion window.\n                               remove - Removes the specified exclusion window.\n                               clear  - Removes all exclusion windows\n   exclusion days of week - List of days of week excluded from execution schedule of the associated Task List.\n                               add    - Adds a new exclusion day of week.\n                               remove - Removes the specified exclusion day of week.\n                               clear  - Removes all exclusion exclusion days of week." + super.getOtherParametersDescription(indent);
    }

    @Override
    protected void setStartTime(ScheduledJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("CLEAR START TIME")) {
            job.setStartTime(null);
        } else if (definition.statement.existsModifier("SET START TIME")) {
            super.setStartTime(job, definition);
        }
    }

    @Override
    protected void setMainParameters(ScheduledJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        this.doSetMainParameters((RepeatingJob)job, definition);
    }

    @Override
    protected void setOtherParameters(ScheduledJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        AlterJobRepeatingOperation.clearExclusionWindows((RepeatingJob)job, definition);
        AlterJobRepeatingOperation.removeExclusionWindows((RepeatingJob)job, definition);
        AlterJobRepeatingOperation.addExclusionWindows((RepeatingJob)job, definition, "addExclusionWindows");
        AlterJobRepeatingOperation.clearExclusionDaysOfWeek((RepeatingJob)job, definition);
        AlterJobRepeatingOperation.removeExclusionDaysOfWeek((RepeatingJob)job, definition);
        AlterJobRepeatingOperation.addExclusionDaysOfWeek((RepeatingJob)job, definition, "addExclusionDows");
    }

    protected static void clearExclusionWindows(RepeatingJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("CLEAR EXCLUSION WINDOWS")) {
            job.clearExclusionWindows();
        }
    }

    protected static void clearExclusionDaysOfWeek(RepeatingJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("CLEAR EXCLUSION DAYS OF WEEK")) {
            job.clearExclusionDaysOfWeek();
        }
    }
}

