/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.job;

import com.streamscape.runtime.mf.operation.scheduler.job.AbstractAlterCreateJobOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.JobType;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.DataspaceVariableReferenceParameter;
import com.streamscape.slex.lang.parameter.DateParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

abstract class AbstractAlterJobOperation
extends AbstractAlterCreateJobOperation {
    AbstractAlterJobOperation(String name, JobType jobType, String jobTypeName, String description) {
        super(jobType);
        this.createDSLSyntax(name);
        this.syntax.setAction("ALTER JOB" + jobTypeName).addActionParameter((SyntaxParameter)((IdentifierParameter)this.createJobNameParameter().addExclusionValue("REPEATING")).setCompletionAdviser(new AbstractAlterCreateJobOperation.TypedJobNameCompletionAdviser(this, JobState.DISABLED)));
        this.addNameModifier();
        this.addTaskListModifier();
        this.addStartTimeModifier();
        this.addMainModifiers();
        this.addOwnerModifier();
        this.addDescriptionModifier();
        this.addOtherModifiers();
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier((AbstractModifier)new Modifier("ATTACH METASET").addParameter(new DataspaceVariableReferenceParameter("Metaset")))).addModifier(new Modifier("DETACH METASET")));
        this.addNotifyModifier();
        this.syntax.setDescription(description);
        this.syntax.setSyntaxDescription(this.createSyntaxDescription());
    }

    @Override
    protected void addStartTimeModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("START TIME", false).addParameter(new DateParameter("StartTime", SCHEDULER_DATE_FORMAT)));
    }

    @Override
    protected void addTaskListModifier() {
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("CLEAR TASKLIST"))).addModifier((AbstractModifier)new Modifier("SET TASKLIST").addParameter(this.createTaskListNameParameterWithAdviser(new TaskListState[0]))));
    }

    protected void addNotifyModifier() {
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(this.createNotifyModifier("ENABLE NOTIFY", true))).addModifier(new Modifier("DISABLE NOTIFY"))).addModifier(new Modifier("CLEAR NOTIFY")));
    }

    @Override
    protected String getMainParametersDescription(String indent) {
        return "   name       " + indent + " - New name of the Job.\n   tasklist   " + indent + " - Task list that is executed by the Job.\n" + indent + "                    set   - Sets the specified Task List to the Job.\n" + indent + "                    clear - Removes the existing Task List from the Job.\n";
    }

    @Override
    protected String getTimeParameterDescription(String indent) {
        return "   start time" + indent + "  - Time when the Job will execute the associated Task List.\n";
    }

    @Override
    protected String getOtherParametersDescription(String indent) {
        return "\n   metaset    " + indent + " - Metaset instance that is passed to the executed Task List.\n" + indent + "                    attach - Attaches the specified Metaset to the Job.\n" + indent + "                    detach - Removes the attached Metaset from the Job.";
    }

    @Override
    protected String getNotifyDescription(String indent) {
        return "\n\n   notify" + indent + "      - Email notifications with the specified parameters.\n           " + indent + "      The following options are supported:\n           " + indent + "         enable  - Enables the email notifications.\n           " + indent + "         disable - Disables the email notifications.\n           " + indent + "         clear   - Clears a list of recipients of the email notifications.\n" + this.getNotifyDescriptionCore(indent);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        this.checkParametersPresence(statement);
        return new AbstractSchedulerOperation.Definition(this.getName(), statement);
    }

    @Override
    protected ScheduledJob getJob(Scheduler scheduler, AbstractSchedulerOperation.Definition definition) throws Exception {
        ScheduledJob job = this.lookupJob(scheduler, definition.statement);
        if (job.getType() != this.jobType) {
            throw new Exception("Job is not " + String.valueOf((Object)this.jobType) + " Job.");
        }
        return job;
    }

    @Override
    protected void setName(ScheduledJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        AbstractAlterJobOperation.setName(job, definition);
    }

    @Override
    protected void setTaskList(Scheduler scheduler, AbstractSchedulerOperation.Definition definition, ScheduledJob job) throws Exception {
        if (definition.statement.existsModifier("CLEAR TASKLIST")) {
            scheduler.setJobTaskList(job.getName(), null);
        } else {
            super.setTaskList(scheduler, definition, job);
        }
    }

    @Override
    protected void setNotify(ScheduledJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("ENABLE NOTIFY")) {
            job.setNotify(true);
            this.setNotifyLevel(job, definition);
            this.setNotifyParameters(job, definition);
        } else if (definition.statement.existsModifier("DISABLE NOTIFY")) {
            job.setNotify(false);
        } else if (definition.statement.existsModifier("CLEAR NOTIFY")) {
            job.setNotifyTo(null);
            job.setNotifySubject(null);
            job.setNotifyBody(null);
        }
    }

    @Override
    protected void setMetaset(ScheduledJob job, AbstractSchedulerOperation.Definition definition, MFSession session) throws Exception {
        if (definition.statement.existsModifier("ATTACH METASET")) {
            job.setExecutionMetaset(this.getMetaset(definition, session));
        } else if (definition.statement.existsModifier("DETACH METASET")) {
            job.setExecutionMetaset(null);
        }
    }
}

