/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler.job;

import com.streamscape.lib.utils.TimeWindow;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.scheduler.job.AbstractJobOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.DayOfWeek;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.JobType;
import com.streamscape.sef.scheduler.NotifyLevel;
import com.streamscape.sef.scheduler.RepeatingJob;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.DateParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.NumericParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

abstract class AbstractAlterCreateJobOperation
extends AbstractJobOperation {
    protected JobType jobType;

    protected AbstractAlterCreateJobOperation(JobType jobType) {
        this.jobType = jobType;
    }

    protected String createSyntaxDescription() {
        String indent = this.isRepeatingJob() ? "           " : "";
        return "Parameters:\n\n" + this.getMainParametersDescription(indent) + this.getJobParametersDescription(indent) + "   description" + indent + " - Description of the Job." + this.getOtherParametersDescription(indent) + this.getNotifyDescription(indent) + AbstractAlterCreateJobOperation.getTimeFormat("\n");
    }

    protected String getLikeDescription(String indent) {
        return "   like" + indent + "        - Creates a new Job based on the existing Job.\n";
    }

    protected String getMainParametersDescription(String indent) {
        return this.getLikeDescription(indent) + "   tasklist   " + indent + " - Task List that is executed by the Job.\n";
    }

    protected String getJobParametersDescription(String indent) {
        return this.isRepeatingJob() ? this.getTimeParameterDescription(indent) + "   interval               - Time interval between consecutive executions of the associated Task List.\n   repeat count           - Count of consecutive executions of the associated Task List.\n" : this.getTimeParameterDescription(indent);
    }

    protected String getTimeParameterDescription(String indent) {
        return "   at time" + indent + "     - Time when the Job will execute the associated Task List.\n";
    }

    protected String getOtherParametersDescription(String indent) {
        return this.isRepeatingJob() ? "\n   exclusion windows      - List of time intervals excluded from execution schedule of the associated Task List.\n   exclusion days of week - List of days of week excluded from execution schedule of the associated Task List." : "";
    }

    protected abstract String getNotifyDescription(String var1);

    protected String getNotifyDescriptionCore(String indent) {
        return "           " + indent + "      If enabled, the Job sends a Mail Event (that can be converted to an email by Mail Sender service)\n           " + indent + "      for each Scheduler Advisory sent during the Job execution.\n           " + indent + "      The following parameters of the event are supported:\n           " + indent + "         to      - List of recipients (addresses) of the email. They must be separated by semicolon.\n           " + indent + "         subject - Subject of the email.\n           " + indent + "         body    - Body of the email.\n           " + indent + "      Parameter may include a reference to Scheduler Template in the format <b>$t:{&lt;TemplateName&gt;}</b>.\n           " + indent + "      Parameter may include the standard macro substitutions (like global variables etc).\n           " + indent + "      It may also include the special macro substitutions:\n           " + indent + "         @fullAdvisory - Scheduler Advisory that causes the email sending (serialized in JSON format).\n           " + indent + "         @advisoryType - Type of Scheduler Advisory that causes the email sending.\n           " + indent + "         @nodeName     - Name of Node the email is sent from.\n           " + indent + "         @jobName      - Name of Job associated with the email.\n           " + indent + "         @listName     - Name of Task List associated with the email.\n           " + indent + "         @taskName     - Name of Task associated with the email.\n           " + indent + "      The following detail levels are supported:\n           " + indent + "         job      - Emails are sent for Scheduler Advisories related with the Job only.\n           " + indent + "         tasklist - Emails are sent for Scheduler Advisories related with the Job and its Task List.\n           " + indent + "         task     - Emails are sent for Scheduler Advisories related with the Job, its Task List and all Tasks.\n";
    }

    protected void addTaskListModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("TASKLIST", false).addParameter(this.createTaskListNameParameterWithAdviser(new TaskListState[0])));
    }

    protected void addStartTimeModifier() {
        this.syntax.addModifier(new CompoundModifier("AtTime", false).addModifier(new ChoiceModifier().addPossibleValues("AT TIME", "@")).addParameter((AbstractParameter)new DateParameter("Time", SCHEDULER_DATE_FORMAT).setName("StartTime")));
    }

    protected void addMainModifiers() {
    }

    protected void addRepeatingModifiers() {
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("INTERVAL", false).addParameter(new NumericParameter("Interval"))).addParameter(AbstractAlterCreateJobOperation.createTimeUnitParameter("TimeUnit", false)));
        this.syntax.addModifier((AbstractModifier)new Modifier("REPEAT COUNT", false).addParameter(new NumericParameter("RepeatCount")));
    }

    protected void addOtherModifiers() {
    }

    protected void addExclusionWindowsModifier(String prefix) {
        this.syntax.addModifier((AbstractModifier)new Modifier(prefix + " EXCLUSION WINDOWS", false).addParameter(new SetParameter(prefix + "ExclusionWindows").addParameter(new DateParameter("StartTime", SCHEDULER_DATE_FORMAT)).addParameter(new DateParameter("EndTime", SCHEDULER_DATE_FORMAT))));
    }

    protected void addExclusionDaysOfWeekModifier(String prefix) {
        this.syntax.addModifier((AbstractModifier)new Modifier(prefix + " EXCLUSION DAYS OF WEEK", false).addParameter(new SetParameter(prefix + "ExclusionDows").addParameter(new EnumParameter("Day", DayOfWeek.class))));
    }

    protected CompoundModifier createNotifyModifier(String token, boolean required) {
        return new CompoundModifier(required).addModifier(new Modifier(token)).addModifier(this.createToModifier()).addModifier(this.createSubjectModifier()).addModifier(this.createBodyModifier()).addModifier((AbstractModifier)new Modifier("LEVEL", false).addParameter(new EnumParameter("DetailLevel", NotifyLevel.class).setDefaultValue(NotifyLevel.JOB.name())));
    }

    protected Modifier createToModifier() {
        return (Modifier)new Modifier("TO", false).addParameter(new StringParameter("To"));
    }

    protected Modifier createSubjectModifier() {
        return (Modifier)new Modifier("SUBJECT", false).addParameter(new StringParameter("Subject"));
    }

    protected Modifier createBodyModifier() {
        return (Modifier)new Modifier("BODY", false).addParameter(new StringParameter("Body"));
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        this.setParameters(scheduler, definition, this.getJob(scheduler, definition), session);
        return new SLResponse();
    }

    protected abstract ScheduledJob getJob(Scheduler var1, AbstractSchedulerOperation.Definition var2) throws Exception;

    protected void setParameters(Scheduler scheduler, AbstractSchedulerOperation.Definition definition, ScheduledJob job, MFSession session) throws Exception {
        this.setOwner(scheduler, definition);
        this.setTaskList(scheduler, definition, job);
        this.setName(job, definition);
        this.setStartTime(job, definition);
        this.setMainParameters(job, definition);
        AbstractAlterCreateJobOperation.setDescription(job, definition);
        this.setOtherParameters(job, definition);
        this.setNotify(job, definition);
        this.setMetaset(job, definition, session);
        scheduler.updateJob(job);
    }

    protected void setName(ScheduledJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
    }

    protected void setOwner(Scheduler scheduler, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("Owner")) {
            scheduler.setJobOwner(AbstractAlterCreateJobOperation.getJobName(definition.statement), definition.statement.getParameter("Owner").getValue());
        }
    }

    protected void setTaskList(Scheduler scheduler, AbstractSchedulerOperation.Definition definition, ScheduledJob job) throws Exception {
        if (definition.statement.existsParameter("TaskListName")) {
            scheduler.setJobTaskList(job.getName(), AbstractAlterCreateJobOperation.getTaskListName(definition.statement));
        }
    }

    protected void setStartTime(ScheduledJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("StartTime")) {
            job.setStartTime(AbstractAlterCreateJobOperation.parseDate(definition.statement.getParameter("StartTime").getValue()));
        }
    }

    protected void setMainParameters(ScheduledJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
    }

    protected void doSetMainParameters(RepeatingJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsParameter("Interval")) {
            job.setRepeatInterval(Long.parseLong(definition.statement.getParameter("Interval").getValue()));
        }
        if (definition.statement.existsParameter("TimeUnit")) {
            job.setRepeatIntervalUnit(TimeUnit.valueOf(definition.statement.getParameter("TimeUnit").getValue().toUpperCase()));
        }
        if (definition.statement.existsParameter("RepeatCount")) {
            job.setRepeatCount(Integer.parseInt(definition.statement.getParameter("RepeatCount").getValue()));
        }
    }

    protected void setOtherParameters(ScheduledJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
    }

    protected static void addExclusionWindows(RepeatingJob job, AbstractSchedulerOperation.Definition definition, String parameterName) throws Exception {
        for (TimeWindow window : AbstractAlterCreateJobOperation.getExclusionWindows(definition, parameterName)) {
            job.addExclusionWindow(window);
        }
    }

    protected static void removeExclusionWindows(RepeatingJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        for (TimeWindow window : AbstractAlterCreateJobOperation.getExclusionWindows(definition, "removeExclusionWindows")) {
            job.removeExclusionWindow(window);
        }
    }

    protected static void addExclusionDaysOfWeek(RepeatingJob job, AbstractSchedulerOperation.Definition definition, String parameterName) throws Exception {
        for (DayOfWeek dow : AbstractAlterCreateJobOperation.getExclusionDaysOfWeek(definition, parameterName)) {
            job.addExclusionDayOfWeek(dow);
        }
    }

    protected static void removeExclusionDaysOfWeek(RepeatingJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        for (DayOfWeek dow : AbstractAlterCreateJobOperation.getExclusionDaysOfWeek(definition, "removeExclusionDows")) {
            job.removeExclusionDayOfWeek(dow);
        }
    }

    private static List<TimeWindow> getExclusionWindows(AbstractSchedulerOperation.Definition definition, String parameterName) throws Exception {
        ArrayList<TimeWindow> result = new ArrayList<TimeWindow>();
        if (definition.statement.existsSet(parameterName)) {
            StatementSetValue excludedTimes = definition.statement.getSet(parameterName);
            for (int i = 0; i < excludedTimes.size(); ++i) {
                result.add(new TimeWindow(AbstractAlterCreateJobOperation.parseDate(excludedTimes.getElement(i).getParameter("StartTime").getValue()), AbstractAlterCreateJobOperation.parseDate(excludedTimes.getElement(i).getParameter("EndTime").getValue())));
            }
        }
        return result;
    }

    private static List<DayOfWeek> getExclusionDaysOfWeek(AbstractSchedulerOperation.Definition definition, String name) throws Exception {
        ArrayList<DayOfWeek> result = new ArrayList<DayOfWeek>();
        if (definition.statement.existsSet(name)) {
            StatementSetValue excludedDows = definition.statement.getSet(name);
            for (int i = 0; i < excludedDows.size(); ++i) {
                result.add(DayOfWeek.valueOf(excludedDows.getElement(i).getParameter("Day").getValue()));
            }
        }
        return result;
    }

    protected abstract void setNotify(ScheduledJob var1, AbstractSchedulerOperation.Definition var2) throws Exception;

    protected void setNotifyParameters(ScheduledJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("TO")) {
            job.setNotifyTo(definition.statement.getParameter("To").getValue());
        }
        if (definition.statement.existsModifier("SUBJECT")) {
            job.setNotifySubject(definition.statement.getParameter("Subject").getValue());
        }
        if (definition.statement.existsModifier("BODY")) {
            job.setNotifyBody(definition.statement.getParameter("Body").getValue());
        }
    }

    protected void setNotifyLevel(ScheduledJob job, AbstractSchedulerOperation.Definition definition) throws Exception {
        if (definition.statement.existsModifier("LEVEL")) {
            job.setNotifyLevel(NotifyLevel.valueOf(definition.statement.getParameter("DetailLevel").getValue().toUpperCase()));
        }
    }

    protected void setMetaset(ScheduledJob job, AbstractSchedulerOperation.Definition definition, MFSession session) throws Exception {
    }

    protected boolean isRepeatingJob() {
        return this.jobType == JobType.REPEATING;
    }

    protected class TypedJobNameCompletionAdviser
    extends AbstractSchedulerOperation.JobNameCompletionAdviser {
        protected TypedJobNameCompletionAdviser(JobState ... states) {
            super(states);
        }

        @Override
        protected Stream<ScheduledJob> getJobs() {
            return ((RuntimeContext)AbstractAlterCreateJobOperation.this.callable).getScheduler().getJobs().stream().filter(job -> job.getType() == AbstractAlterCreateJobOperation.this.jobType && this.matchesState((ScheduledJob)job));
        }
    }
}

