/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler;

import com.streamscape.omf.serializer.TextSerializer;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerObject;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;
import java.util.stream.Collectors;

public class UpdateSchedulerSetOperation
extends AbstractSchedulerOperation {
    public static final String NAME = "update scheduler set";

    public UpdateSchedulerSetOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("UPDATE SCHEDULER SET");
        this.syntax.addModifier(((CompoundModifier)new CompoundModifier().setSyntaxHintSpace()).addModifier(new ChoiceModifier().addPossibleValues("JOB", "TASKLIST")).addParameter((AbstractParameter)new IdentifierParameter("Name").setCompletionAdviser(new CompletionAdviser())).addModifier(new Modifier("=")).addParameter((AbstractParameter)new ExpressionParameter("SerializedObject").setEndDelimiterToCommandEnd()));
        this.syntax.setDescription("Updates the specified Job or Task List using the serialized object (in JSON format by default).");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        if (definition.object != null) {
            String name = definition.object.getName();
            if (definition.object instanceof ScheduledJob) {
                this.updateJob(scheduler, name, (ScheduledJob)definition.object);
                return new SLResponse();
            } else {
                if (!(definition.object instanceof TaskList)) throw new Exception("Wrong object!");
                this.updateTaskList(scheduler, name, (TaskList)definition.object);
            }
            return new SLResponse();
        } else {
            String name = definition.statement.getParameter("Name").getValue();
            if (definition.statement.existsModifier("JOB")) {
                this.updateJob(scheduler, name, (ScheduledJob)this.getSerializer(definition).deserialize(definition.statement.getParameter("SerializedObject").getValue()));
                return new SLResponse();
            } else {
                if (!definition.statement.existsModifier("TASKLIST")) return new SLResponse();
                this.updateTaskList(scheduler, name, (TaskList)this.getSerializer(definition).deserialize(definition.statement.getParameter("SerializedObject").getValue()));
            }
        }
        return new SLResponse();
    }

    private void updateJob(Scheduler scheduler, String name, ScheduledJob job) throws Exception {
        this.checkObject(scheduler.getJob(name), job, "Job");
        scheduler.updateJob(job);
    }

    private void updateTaskList(Scheduler scheduler, String name, TaskList taskList) throws Exception {
        this.checkObject(scheduler.getTaskList(name), taskList, "Task list");
        scheduler.updateTaskList(taskList);
    }

    private void checkObject(SchedulerObject oldObject, SchedulerObject newObject, String objectType) throws Exception {
        if (oldObject == null) {
            throw new Exception(objectType + " not found.");
        }
        if (!oldObject.getOID().equals(newObject.getOID())) {
            throw new Exception("Object unique identifiers not match.");
        }
    }

    private TextSerializer getSerializer(Definition definition) {
        return definition.statement.existsModifier("XML") ? ((RuntimeContext)this.callable).getXSerializer() : ((RuntimeContext)this.callable).getJSONSerializer();
    }

    protected class CompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext> {
        protected CompletionAdviser() {
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            String script = processedScript.trim().toLowerCase();
            if (script.endsWith("job")) {
                return ((RuntimeContext)UpdateSchedulerSetOperation.this.callable).getScheduler().getJobs().stream().filter(this::matchesState).map(NamedObject::getName).collect(Collectors.toList());
            }
            if (script.endsWith("tasklist")) {
                return ((RuntimeContext)UpdateSchedulerSetOperation.this.callable).getScheduler().getTaskLists().stream().filter(this::matchesState).map(rec$ -> ((TaskList)rec$).getName()).collect(Collectors.toList());
            }
            return null;
        }

        protected boolean matchesState(ScheduledJob job) {
            return job.getState() == JobState.DISABLED;
        }

        protected boolean matchesState(TaskList taskList) {
            return taskList.getState() == TaskListState.DISABLED;
        }
    }

    public static class Definition
    extends AbstractSchedulerOperation.Definition {
        private SchedulerObject object;

        public Definition(SchedulerObject object) {
            super(UpdateSchedulerSetOperation.NAME, null);
            this.object = object;
        }

        Definition(DSLStatement statement) {
            super(UpdateSchedulerSetOperation.NAME, statement);
        }
    }
}

