/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler;

import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerObject;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SelectSchedulerSetOperation
extends AbstractSchedulerOperation {
    public static final String NAME = "select scheduler set";

    public SelectSchedulerSetOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SELECT SCHEDULER SET");
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("Filters", false).addModifier(new Modifier("ALL"))).addModifier(new CompoundModifier().addModifier(SelectSchedulerSetOperation.createObjectsModifier("JOBS")).addModifier(SelectSchedulerSetOperation.createObjectsModifier("TASKLISTS")).addModifier(SelectSchedulerSetOperation.createObjectsModifier("METASETS")).addModifier(new Modifier("METASET_INSTANCES", false)).addModifier(new Modifier("TRIGGERS", false)).addModifier(new CompoundModifier(false).addModifier(new Modifier("EXECS")).addModifier(this.createFromToModifier("Execs")).addModifier(this.createWhereModifier("Execs"))).addModifier((AbstractModifier)new Modifier("JOB", false).addParameter(this.createJobNameParameterWithAdviser(new JobState[0]))).addModifier(new CompoundModifier(false).addModifier((AbstractModifier)new Modifier("TASKLIST").addParameter(this.createTaskListNameParameterWithAdviser(new TaskListState[0]))).addModifier((AbstractModifier)this.createExecModifier(false, false).setRequired(false))).addModifier((AbstractModifier)new Modifier("METASET", false).addParameter(this.createMetasetNameParameterWithAdviser())).addModifier((AbstractModifier)new Modifier("METASET_INSTANCE FOR", false).addParameter((SyntaxParameter)this.createTaskListNameParameterWithAdviser(new TaskListState[0]).setName("MetasetListName"))).addModifier((AbstractModifier)new Modifier("TRIGGER", false).addParameter(this.createTriggerNameParameterWithAdviser())))).setCompactSyntax("[{ all | * }\n |\n   [jobs [like '<Pattern>']] [tasklists [like '<Pattern>']] [metasets [like '<Pattern>'] [metaset_instances]]\n   [execs [[from '<FromTime>'] [to '<ToTime>']] [where (<Condition>)]]\n |\n   [job <JobName>]\n   [tasklist <TaskListName> [exec [{ id <ExecId> |\n                                     last [{ <N> | * [[from '<FromTime>'] [to '<ToTime>']] }] [where (<Condition>)]]]\n   [metaset <MetasetName>]\n   [metaset_instance for <TaskListName>] }]"));
        this.syntax.addModifier(new CompoundModifier("AsFormat", false).addModifier(new Modifier("AS")).addModifier((AbstractModifier)new ChoiceModifier("Format").addPossibleValues("XML").addModifier(new CompoundModifier().addModifier(new Modifier("JSON")).addModifier(new Modifier("PRETTY", false)))));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Returns an object containing the specified Scheduler data in the current node.\nAll possible data except Executions will be returned if no parameters are specified.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   all               - Returns all possible Scheduler data including Executions.\n   jobs              - Includes all Jobs data into the result object.\n      like           - Includes a list of Jobs whose name matches the specified pattern.\n   tasklists         - Includes all Task Lists data into the result object.\n      like           - Includes a list of Task Lists whose name matches the specified pattern.\n   metasets          - Includes all Metasets data into the result object.\n      like           - Includes a list of Metasets whose name matches the specified pattern.\n   metaset_instances - Includes all Metaset instances data into the result object.\n   execs             - Includes all Executions data into the result object.\n      from           - Includes Executions started at or after the specified time.\n      to             - Includes Executions started at or before the specified time.\n      where          - Filters the result Executions by the specified condition, which is applied to each Task in the result.\n                       This condition uses the Event Selector syntax and takes the Completion Facets as a source of its variables.\n                       So, this option filters the Executions whose Tasks have the Completion Facets that match the specified condition.\n   job               - Includes an object representing the specified Job into the result object.\n   tasklist          - Includes an object representing the specified Task List into the result object.\n      exec           - Additionally includes the active Execution of the Task List.\n      exec id        - Additionally includes the specified Execution of the Task List.\n      exec last      - Additionally includes the last Execution of the Task List.\n      exec last &lt;N&gt;  - Additionally includes the specified count of last Executions of the Task List.\n         where       - See description above.\n      exec last *    - Additionally includes a list of all Executions of the Task List.\n         from        - Additionally includes a list of Executions started at or after the specified time.\n         to          - Additionally includes a list of Executions started at or before the specified time.\n         where       - See description above.\n   metaset           - Includes an object representing the specified Metaset into the result object.\n   metaset_instance  - Includes an object representing a Metaset instance for the specified Task List into the result object.\n   as xml            - Returns the result object in XML format.\n   as json           - Returns the result object in JSON format.\n      pretty         - Returns the result object in pretty JSON format.\n   at node           - Executes this command in the specified node.\n   at domain         - Executes this command in all nodes of Sysplex.\n\n" + SelectSchedulerSetOperation.getLikeModifierDescription("   ", "\n"));
        this.syntax.setExamples("select scheduler set\nselect scheduler set at node TestNode\nselect scheduler set as xml\nselect scheduler set at node TestNode as json\nselect scheduler set as json pretty\nselect scheduler set tasklists like 'Test%'\nselect scheduler set jobs\nselect scheduler set jobs tasklists as json\nselect scheduler set jobs like 'Test.*' tasklists like 'Test%' as json\nselect scheduler set metasets like 'Test%'\nselect scheduler set metaset_instances\nselect scheduler set jobs tasklists metasets as json pretty\nselect scheduler set execs\nselect scheduler set execs where (id=12345)\nselect scheduler set execs from '05-31-2019 08:31:12 PM'\nselect scheduler set execs to '06-31-2019 08:31:12 PM'\nselect scheduler set execs from '05-31-2019 08:31:12 PM' to '06-31-2019 08:31:12 PM'\nselect scheduler set execs from '05-31-2019 08:31:12 PM' to '06-31-2019 08:31:12 PM' where (id=12345 and key='xyz')\nselect scheduler set job TestJob\nselect scheduler set job TestJob tasklist TestList\nselect scheduler set tasklist TestList exec\nselect scheduler set tasklist TestList exec id c3aa9224-6f2d-4212-8e82-fb894f8e10f8\nselect scheduler set tasklist TestList exec last\nselect scheduler set tasklist TestList exec last 5\nselect scheduler set tasklist TestList exec last 5 where (id=12345)\nselect scheduler set tasklist TestList exec last *\nselect scheduler set tasklist TestList exec last * where (id=12345 and key='xyz')\nselect scheduler set tasklist TestList exec last * from '05-31-2019 08:31:12 PM'\nselect scheduler set tasklist TestList exec last * to '06-31-2019 08:31:12 PM'\nselect scheduler set tasklist TestList exec last * from '05-31-2019 08:31:12 PM' to '06-31-2019 08:31:12 PM'\nselect scheduler set tasklist TestList exec last * from '05-31-2019 08:31:12 PM' to '06-31-2019 08:31:12 PM' where (id=12345)\nselect scheduler set metaset TestMetaset\nselect scheduler set metaset_instance for TestList");
    }

    private static CompoundModifier createObjectsModifier(String name) {
        return new CompoundModifier(false).addModifier(new Modifier(name)).addModifier(SelectSchedulerSetOperation.createLikeModifierWithUniqueName(SelectSchedulerSetOperation.getPatterParameterName(name), false));
    }

    private static String getPatterParameterName(String modifierName) {
        return StringUtils.toCapitalized(modifierName.toLowerCase()) + "Pattern";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if ((statement.existsModifier("JOB") || statement.existsModifier("TASKLIST") || statement.existsModifier("METASET") || statement.existsModifier("METASET_INSTANCE FOR") || statement.existsModifier("TRIGGER")) && (statement.existsModifier("JOBS") || statement.existsModifier("TASKLISTS") || statement.existsModifier("METASETS") || statement.existsModifier("METASET_INSTANCES") || statement.existsModifier("TRIGGERS") || statement.existsModifier("EXECS"))) {
            throw new ParsingException(this.getSyntaxErrorMessage("Parameters for a list of objects and a single object cannot be specified together."));
        }
        Definition definition = new Definition(this, statement);
        if ((statement.existsModifier("XML") || statement.existsModifier("JSON")) && definition.nodeName != null && definition.nodeName.equals("*")) {
            throw new ParsingException(this.getSyntaxErrorMessage("Parameters 'at domain' and 'as' cannot be specified together."));
        }
        return definition;
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        HashMap<String, Object> result;
        Definition definition = (Definition)statement;
        DSLStatement dslStatement = definition.statement;
        Scheduler scheduler = this.getScheduler(session);
        if (definition.statement.existsModifier("JOB") || definition.statement.existsModifier("TASKLIST") || definition.statement.existsModifier("METASET") || definition.statement.existsModifier("METASET_INSTANCE FOR") || definition.statement.existsModifier("TRIGGER")) {
            map = new HashMap<String, Object>();
            if (definition.statement.existsModifier("JOB")) {
                map.put("JOB", this.lookupJob(scheduler, definition.statement));
            }
            if (definition.statement.existsModifier("TASKLIST")) {
                TaskList taskList = SelectSchedulerSetOperation.lookupTaskList(scheduler, definition.statement);
                map.put("TASKLIST", taskList);
                if (definition.exec != null) {
                    AbstractSchedulerOperation.ExecDefinition exec = definition.exec;
                    if (exec.eid != null) {
                        map.put("EXECS", scheduler.getExecution(taskList.getName(), exec.eid));
                    } else if (exec.last) {
                        List<TaskListExecution> executions = exec.N == -1 ? this.getExecutions(scheduler, taskList.getName(), exec) : scheduler.getLastExecutions(taskList.getName(), exec.N);
                        map.put("EXECS", SelectSchedulerSetOperation.filterByTaskFacets(executions, exec.condition));
                    } else {
                        map.put("EXECS", taskList.getExecution());
                    }
                }
            }
            if (definition.statement.existsModifier("METASET")) {
                map.put("METASET", this.lookupMetaset(scheduler, definition.statement));
            }
            if (definition.statement.existsModifier("METASET_INSTANCE FOR")) {
                map.put("METASET_INSTANCE", this.lookupMetasetInstance(scheduler, definition.statement.getParameter("MetasetListName").getValue()));
            }
            if (definition.statement.existsModifier("TRIGGER")) {
                map.put("TRIGGER", this.getTrigger(definition.statement));
            }
            result = map;
        } else {
            map = new HashMap();
            if (definition.needsAll() || definition.statement.existsModifier("JOBS")) {
                map.put("JOBS", this.convert(this.getJobs(definition, session)));
            }
            if (definition.needsAll() || definition.statement.existsModifier("TASKLISTS")) {
                map.put("TASKLISTS", this.convert(this.getTaskLists(definition, session)));
            }
            if (definition.needsAll() || definition.statement.existsModifier("METASETS")) {
                map.put("METASETS", this.convert(this.getMetasets(definition, session)));
            }
            if (definition.needsAll() || definition.statement.existsModifier("METASET_INSTANCES")) {
                map.put("METASET_INSTANCES", this.convert(scheduler.getAllMetasetInstances()));
            }
            if (definition.needsAll() || definition.statement.existsModifier("TRIGGERS")) {
                map.put("TRIGGERS", this.convert(scheduler.getTriggers()));
            }
            if (definition.exec != null) {
                map.put("EXECS", this.convert(SelectSchedulerSetOperation.getAllExecutions(scheduler, definition.exec)));
            }
            result = map;
        }
        if (definition.statement.existsModifier("XML")) {
            return new SLResponse(((RuntimeContext)this.callable).getXSerializer().serialize(result));
        }
        if (definition.statement.existsModifier("JSON")) {
            JSONSerializer serializer = ((RuntimeContext)this.callable).getJSONSerializer();
            if (definition.statement.existsModifier("PRETTY")) {
                serializer = serializer.withPrettyPrint(true);
            }
            return new SLResponse(serializer.serialize(result));
        }
        RowSet rowSet = new RowSet(SelectSchedulerSetOperation.createResultDescriptor());
        SelectSchedulerSetOperation.addValues(rowSet, node.getName(), result);
        return new SLResponse(rowSet);
    }

    private List<ScheduledJob> getJobs(Definition definition, MFSession session) throws Exception {
        return this.getObjects(definition, session, "JOBS", Scheduler::getJobs);
    }

    private List<TaskList> getTaskLists(Definition definition, MFSession session) throws Exception {
        return this.getObjects(definition, session, "TASKLISTS", Scheduler::getTaskLists);
    }

    private List<Metaset> getMetasets(Definition definition, MFSession session) throws Exception {
        return this.getObjects(definition, session, "METASETS", Scheduler::getMetasets);
    }

    private <T extends SchedulerObject> List<T> getObjects(Definition definition, MFSession session, String modifierName, Function<Scheduler, List<T>> objectsGetter) throws Exception {
        Scheduler scheduler = this.getScheduler(session);
        String likePattern = SelectSchedulerSetOperation.getLikeParameterValue(definition.statement, SelectSchedulerSetOperation.getPatterParameterName(modifierName));
        if (likePattern != null) {
            Pattern pattern = SelectSchedulerSetOperation.compileExtendedPattern(likePattern);
            return objectsGetter.apply(scheduler).stream().filter(object -> pattern.matcher(object.getName()).matches()).collect(Collectors.toList());
        }
        return objectsGetter.apply(scheduler);
    }

    private Map<String, Object> convert(List<? extends SchedulerObject> objects) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        objects.forEach(object -> result.put(object.getOID().toString(), object));
        return result;
    }

    private Map<String, Object> convert(Map<UUID, ?> objects) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        objects.forEach((key, value) -> result.put(key.toString(), value));
        return result;
    }

    private List<TaskListExecution> getExecutions(Scheduler scheduler, String listName, AbstractSchedulerOperation.ExecDefinition exec) throws Exception {
        if (exec.fromTime != null || exec.toTime != null) {
            return scheduler.getExecutions(listName, exec.fromTime, exec.toTime);
        }
        return scheduler.getExecutions(listName);
    }

    private static Map<UUID, List<TaskListExecution>> filterByTaskFacets(Map<UUID, List<TaskListExecution>> executions, SelectorExpression condition) {
        if (condition == null) {
            return executions;
        }
        HashMap<UUID, List<TaskListExecution>> result = new HashMap<UUID, List<TaskListExecution>>();
        executions.forEach((key, value) -> {
            List<TaskListExecution> filteredExecs = SelectSchedulerSetOperation.filterByTaskFacets(value, condition);
            if (!filteredExecs.isEmpty()) {
                result.put((UUID)key, filteredExecs);
            }
        });
        return result;
    }

    private Date getTimeParameter(DSLStatement statement, String parameterName) throws ParsingException {
        return statement.existsParameter(parameterName) ? SelectSchedulerSetOperation.parseDate(statement.getParameter(parameterName).getValue()) : null;
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        SelectSchedulerSetOperation.addColumn(result, "Node");
        SelectSchedulerSetOperation.addGenericColumn(result, "Scheduler Set");
        return result;
    }

    static class Definition
    extends AbstractSchedulerOperation.Definition {
        private AllFilter allFilter;
        AbstractSchedulerOperation.ExecDefinition exec;
        private String nodeName;

        Definition(AbstractSchedulerOperation operation, DSLStatement statement) throws ParsingException {
            super(SelectSchedulerSetOperation.NAME, statement);
            if (statement.existsModifier("ALL")) {
                this.allFilter = AllFilter.FULL;
            } else if (!(statement.existsModifier("JOBS") || statement.existsModifier("TASKLISTS") || statement.existsModifier("TRIGGERS") || statement.existsModifier("METASETS") || statement.existsModifier("METASET_INSTANCES") || statement.existsModifier("EXECS"))) {
                this.allFilter = AllFilter.NO_EXECS;
            }
            if (this.allFilter == AllFilter.FULL || statement.existsModifier("EXECS") || statement.existsModifier("EXEC")) {
                this.exec = new AbstractSchedulerOperation.ExecDefinition(operation, statement);
            }
            this.nodeName = AtNodeOrAtDomainModifier.getValue(statement);
        }

        boolean needsAll() {
            return this.allFilter == AllFilter.FULL || this.allFilter == AllFilter.NO_EXECS;
        }
    }

    static enum AllFilter {
        FULL,
        NO_EXECS;

    }
}

