/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler;

import com.streamscape.lib.utils.TimeWindow;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.List;

public class ListTimeWindowsOperation
extends AbstractSchedulerOperation {
    public static final String NAME = "list time windows";

    public ListTimeWindowsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST TIME WINDOWS");
        this.syntax.setDescription("Returns a list of all time windows in the sysplex.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListTimeWindowsOperation.createResultDescriptor());
        List<TimeWindow> windows = ((RuntimeContext)this.callable).getScheduler().getTimeWindows();
        for (TimeWindow window : ((RuntimeContext)this.callable).getScheduler().getTimeWindows()) {
            result.addToRowSet(new Object[]{window.getName(), ListTimeWindowsOperation.formatDate(window.getStartTime()), ListTimeWindowsOperation.formatDate(window.getEndTime())});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListTimeWindowsOperation.addColumn(result, "Name");
        ListTimeWindowsOperation.addColumn(result, "Start Time");
        ListTimeWindowsOperation.addColumn(result, "End Time");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListTimeWindowsOperation.NAME);
        }
    }
}

