/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.RepeatingJob;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerState;
import com.streamscape.sef.scheduler.SingleJob;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import java.util.List;

public class DescribeSchedulerOperation
extends AbstractSchedulerOperation {
    public static final String NAME = "describe scheduler";

    public DescribeSchedulerOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE SCHEDULER");
        this.syntax.addModifier(new ChoiceModifier(false).addPossibleValues("SESSION", "DATASPACE", "DATASPACE HEALTH", "DATASPACE CONSISTENCY", "COLLECTIONS", "COLLECTIONS HEALTH", "COLLECTIONS CONSISTENCY"));
        this.syntax.setDescription("Shows information about the Scheduler in the current node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   session         - Shows information about the dataspace session used by the Scheduler.\n   dataspace       - Shows information about the dataspace used by the Scheduler.\n      health       - Shows information about the health of the Scheduler dataspace.\n      consistency  - Shows information about the consistency of the Scheduler dataspace.\n   collections     - Shows information about the dataspace collections used by the Scheduler.\n      health       - Shows information about the health of the Scheduler dataspace collections.\n      consistency  - Shows information about the consistency of the Scheduler dataspace collections.");
        this.syntax.setExamples("describe scheduler\ndescribe scheduler session\ndescribe scheduler dataspace\ndescribe scheduler dataspace health\ndescribe scheduler dataspace consistency\ndescribe scheduler collections\ndescribe scheduler collections health\ndescribe scheduler collections consistency");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSchedulerOperation.Definition(NAME, statement);
    }

    @Override
    protected void checkSchedulerReady() throws Exception {
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractSchedulerOperation.Definition definition = (AbstractSchedulerOperation.Definition)statement;
        Scheduler scheduler = this.getScheduler(session);
        RowSet rowSet = null;
        if (definition.statement.existsModifier("SESSION")) {
            rowSet = DescribeSchedulerOperation.describeSession(scheduler);
        } else if (definition.statement.existsModifier("DATASPACE")) {
            rowSet = DescribeSchedulerOperation.describeDataspace(scheduler);
        } else if (definition.statement.existsModifier("DATASPACE HEALTH")) {
            rowSet = DescribeSchedulerOperation.describeDataspaceHealth(scheduler);
        } else if (definition.statement.existsModifier("DATASPACE CONSISTENCY")) {
            rowSet = DescribeSchedulerOperation.describeDataspaceConsistency(scheduler);
        } else if (definition.statement.existsModifier("COLLECTIONS")) {
            rowSet = DescribeSchedulerOperation.describeCollections(scheduler);
        } else if (definition.statement.existsModifier("COLLECTIONS HEALTH")) {
            rowSet = DescribeSchedulerOperation.describeCollectionsHealth(scheduler);
        } else if (definition.statement.existsModifier("COLLECTIONS CONSISTENCY")) {
            rowSet = DescribeSchedulerOperation.describeCollectionsConsistency(scheduler);
        } else {
            SchedulerState state = scheduler.getState();
            if (state == SchedulerState.ACTIVE) {
                rowSet = this.describeGeneral(scheduler);
            } else {
                rowSet = new RowSet(DescribeSchedulerOperation.createSimpleResultDescriptor());
                DescribeSchedulerOperation.addValues(rowSet, new Object[]{"State", state});
            }
        }
        return new SLResponse(rowSet);
    }

    private RowSet describeGeneral(Scheduler scheduler) throws Exception {
        RowSet result = new RowSet(DescribeSchedulerOperation.createSimpleResultDescriptor());
        DescribeSchedulerOperation.addValues(result, new Object[]{"State", SchedulerState.ACTIVE});
        DescribeSchedulerOperation.addValues(result, "Dataspace Session ID", scheduler.getSessionId());
        List<TaskList> taskLists = scheduler.getTaskLists();
        DescribeSchedulerOperation.addValues(result, "Total Task Lists", taskLists.size());
        DescribeSchedulerOperation.addValues(result, "Running Task Lists", taskLists.stream().filter(x$0 -> AbstractSchedulerOperation.isRunning(x$0)).count());
        List<ScheduledJob> jobs = scheduler.getJobs();
        DescribeSchedulerOperation.addValues(result, "Total Single Jobs", jobs.stream().filter(job -> job instanceof SingleJob).count());
        DescribeSchedulerOperation.addValues(result, "Total Repeating Jobs", jobs.stream().filter(job -> job instanceof RepeatingJob).count());
        DescribeSchedulerOperation.addValues(result, "Running Jobs", jobs.stream().filter(x$0 -> AbstractSchedulerOperation.isRunning(x$0)).count());
        DescribeSchedulerOperation.addValues(result, "Metasets", scheduler.listMetasets().size());
        return result;
    }
}

