/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler;

import com.streamscape.lib.utils.TimeWindow;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.DateParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.Date;

public class CreateTimeWindowOperation
extends AbstractSchedulerOperation {
    public static final String NAME = "create time window";

    public CreateTimeWindowOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE TIME WINDOW").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("START TIME").addParameter(new DateParameter("StartTime", SCHEDULER_DATE_FORMAT))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("END TIME").addParameter(new DateParameter("EndTime", SCHEDULER_DATE_FORMAT))).setSyntaxHintSpace());
        this.syntax.setDescription("Creates a new time window.\n\n" + CreateTimeWindowOperation.getTimeFormat());
        this.syntax.setExamples("create time window Holidays start time '01-01-2013 08:00:00 AM' end time '01-10-2013 08:00:00 PM'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue(), CreateTimeWindowOperation.parseDate(statement.getParameter("StartTime").getValue()), CreateTimeWindowOperation.parseDate(statement.getParameter("EndTime").getValue()));
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ((RuntimeContext)this.callable).getScheduler().addTimeWindow(new TimeWindow(definition.windowName, definition.startTime, definition.endTime));
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String windowName;
        private Date startTime;
        private Date endTime;

        public Definition(String windowName, Date startTime, Date endTime) {
            super(CreateTimeWindowOperation.NAME);
            this.windowName = windowName;
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }
}

