/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.scheduler;

import com.streamscape.lib.utils.TimeWindow;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.DateParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.Date;

public class AlterTimeWindowOperation
extends AbstractSchedulerOperation {
    public static final String NAME = "alter time window";

    public AlterTimeWindowOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER TIME WINDOW").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("START TIME", false).addParameter(new DateParameter("StartTime", SCHEDULER_DATE_FORMAT))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("END TIME", false).addParameter(new DateParameter("EndTime", SCHEDULER_DATE_FORMAT))).setSyntaxHintSpace());
        this.syntax.setDescription("Alters the specified time window.\n\n" + AlterTimeWindowOperation.getTimeFormat());
        this.syntax.setExamples("alter time window Holidays start time '01-02-2013 08:00:00 AM'\nalter time window Holidays start time '01-01-2013 08:00:00 AM' end time '01-09-2013 08:00:00 PM'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue(), statement.existsParameter("StartTime") ? AlterTimeWindowOperation.parseDate(statement.getParameter("StartTime").getValue()) : null, statement.existsParameter("EndTime") ? AlterTimeWindowOperation.parseDate(statement.getParameter("EndTime").getValue()) : null);
    }

    @Override
    protected SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        TimeWindow window = ((RuntimeContext)this.callable).getScheduler().getTimeWindow(definition.windowName);
        if (window == null) {
            throw new Exception("Time window not found.");
        }
        ((RuntimeContext)this.callable).getScheduler().setTimeWindow(new TimeWindow(definition.windowName, definition.startTime != null ? definition.startTime : window.getStartTime(), definition.endTime != null ? definition.endTime : window.getEndTime()));
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String windowName;
        private Date startTime;
        private Date endTime;

        public Definition(String windowName, Date startTime, Date endTime) {
            super(AlterTimeWindowOperation.NAME);
            this.windowName = windowName;
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }
}

