/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.repository;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.repository.AbstractRepositoryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ListArchivesOperation
extends AbstractRepositoryOperation {
    public static final String NAME = "list archives";

    public ListArchivesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST ARCHIVES");
        this.syntax.setDescription("Returns a list of all archives in the current node.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListArchivesOperation.createResultDescriptor());
        for (String archive : ((RuntimeContext)this.callable).getRepositoryAccessor().listArchives()) {
            result.addToRowSet(new Object[]{archive});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ListArchivesOperation.addColumn(result, "Archive");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListArchivesOperation.NAME);
        }
    }
}

