/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.repository;

import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorRepositoryUtils;
import com.streamscape.lib.jar.JarFile;
import com.streamscape.lib.loader.MemoryJarFile;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeManifestManager;
import com.streamscape.runtime.mf.operation.frm.FrmEntity;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.runtime.mf.operation.frm.FrmFileReader;
import com.streamscape.runtime.mf.operation.frm.FrmFileWriter;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.advisory.AdvisoryEvent;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.DeltaEvent;
import com.streamscape.sdo.event.ExceptionEvent;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.dispatcher.AbstractExportImportOperation;
import com.streamscape.sef.dispatcher.AbstractRuntimeContext;
import com.streamscape.sef.dispatcher.SLOperationLogger;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.scheduler.AbstractExecutableObject;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.utils.RepositoryUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.BooleanParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class ImportOperation
extends AbstractExportImportOperation {
    public static final String NAME = "import";

    public ImportOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setDescription("Imports the specified artifacts from the specified location into the current node.\nExisting artifacts will be replaced.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   <ArtifactType> - Type of the artifact.\n   <ArtifactName> - Name of the artifact.\n                    Value * means that all suitable artifacts found in the location will be imported.\n\nThe following artifact types are supported:\n\n      client-factory  - Client Connection Factory Object. Stored in 'clients' area of Repository. Name format is <FactoryType>.<FactoryName>.\n      db-factory      - DB Connection Factory Object. Stored in 'jdbc' area of Repository. Name format is <FactoryType>.<FactoryName>.\n      msg-factory     - Message Connection Factory Object. Stored in 'transports' area of Repository. Name format is <FactoryType>.<FactoryName>.\n      service         - Service Configuration Object. Stored in 'service' area of Repository. Name format is <ServiceType>.<ServiceName>.\n      package         - Package Object. Stored in 'pkg' area of Repository. Name format is <PackageType>.<PackageName>.\n                        Package is imported with all its archives. Package is registered in Package Manifest and loaded after importing.\n                        All semantic types related to this package are also imported (i.e. types whose classes belong to the package).\n      archive         - Archive (JAR file). Stored in 'lib' area of Repository. Name format is <ArchiveName>.jar.\n      ext-archive     - Extension archive (JAR file). Stored in 'ext' area of Repository. Name format is <ArchiveName>.jar.\n      sdo             - Semantic Type (SDO). Stored in 'types' area of Repository. Name format is <TypeName>.\n                        Semantic type is imported with the related package or extension archive where the type's class is located.\n                        Such package is registered in Package Manifest and loaded after importing.\n      event-prototype - Event prototype. Stored in 'objects/sys/datagram/prototype' area of Repository. Name format is <EventId>.\n      file-descriptor - File Descriptor. Stored in 'objects/file/descriptor' area of Repository. Name format is FileDescriptor.<FileName>.\n      job             - Scheduler Job. Name format is <JobName>.\n                        Job is imported with its Task List if exists. Job will be in a disabled state after importing.\n      tasklist        - Scheduler Task List. Name format is <ListName>.\n                        Task List will be in a disabled state after importing.\n      mlcache         - Models and dictionaries for NLP services. Name format is <ServiceName> or <ModelName> or <ServiceName>/<ModelName>.\n      object          - Any object from .tfcache/objects directory, namespace should be specified.\n\n   from           - Path to the location from where the artifacts will be imported.\n                    Location must point to an existing FRM file for all artifact types, except archive and ext-archive.\n                    For archives the location can also point to an existing directory.\n\nOptional parameters:\n\n   no load        - Package will not be registered in Package Manifest and loaded after importing.\n                    Semantic types related to this package will not be imported.\n                    This parameter is only applicable for Package artifacts.\n   global         - Specifies a scope of an imported package. Global packages are replicated to all nodes of Sysplex.\n                    Packages of 'sdo' type are global by default, packages of 'collection' type are local.\n                    This parameter is only applicable for Package or SDO artifacts.\n   enable         - Enables Jobs and Task Lists after importing.\n                    This parameter is only applicable for Job or Task List artifacts.\n   name           - Specifies a new name for the imported Task List.\n                    This parameter is mandatory if the Task List is imported from a Task List Model.\n                    This parameter is only applicable for Task List artifacts.\n   model          - Indicates to import the specified Task List Model to another Model instead of a regular Task List.\n                    This parameter is only applicable for importing from a Task List Model.\n                    This parameter is only applicable for Task List artifacts.\n   force          - Forces an overwrite of active archives even if there are dependent semantic types.\n   no overwrite   - Existing event prototype will not be overwritten after importing, just skipped.\n   with ancestors - Imports semantic types with all their ancestors.\n                    This parameter is applicable for SDO artifacts only.\n   with wait      - Executes this operation in synchronous mode (waits until completion or reply timeout expiration).");
        this.syntax.setExamples("import client-factory (FTPClient.Test.cfo) from 'C:/Test/Test.frm'\nimport db-factory (SQLServer.Test1, SQLServer.Test2) from 'C:/Test/Test.frm'\nimport service (TestService.Test) from 'C:/Test/Test.frm'\nimport package (sdo.Test, sdo.Test1) from 'C:/Test/Test.frm'\nimport package (sdo.Test) from 'C:/Test/Test.frm' no load\nimport archive (employee.jar) from 'C:/Test/Test.frm'\nimport archive (employee.jar) from 'C:/Test'\nimport ext-archive (mail.jar) from 'C:/Test/Test.frm'\nimport ext-archive (*) from 'C:/Test'\nimport sdo (Employee, Department) from 'C:/Test/Test.frm'\nimport sdo (Employee) from 'C:/Test/Test.frm' with ancestors\nimport sdo (*) from 'C:/Test/Test.frm'\nimport sdo (Employee) from 'C:/Test/Test.frm' no load\nimport event-prototype (my.event) from 'C:/Test/Test.frm'\nimport event-prototype (*) from 'C:/Test/Test.frm'\nimport file-descriptor (FileDescriptor.User) from 'C:/Test/Test.frm'\nimport file-descriptor (*) from 'C:/Test/Test.frm'\nimport job (Test) from 'C:/Test/Test.frm'\nimport tasklist (*) from 'C:/Test/Test.frm'\nimport tasklist (Test) from 'C:/Test/Test.frm' name Test1\nimport tasklist (Test) from 'C:/Test/Test.frm' name Test1 model\nimport tasklist (Test) from 'C:/Test/Test.frm' model\nimport mlcache (*) from 'C:/Test/Test.frm'\nimport mlcache (TXCluster, CTExtractor/en-ner-location.bin.mlm) from 'C:/Test/Test.frm'\nimport object (http/request/MyDataspace/MyServer/*) from './my_frm.frm'\nimport object (http/request/MyDataspace/MyServer/HTTPRequest.MyRequest.xdo) from './my_frm.frm'\nimport object (http/request/MyDataspace/MyServer/*) (http/request/MyDataspace/AnotherServer/) from './my_frm.frm'\nimport object (http/request/MyDataspace/MyServer/HTTPRequest.request1.xdo, http/request/MyDataspace/MyServer/HTTPRequest.request2.xdo) from './my_frm.frm'\nimport facets (Skills) from 'C:/Test/Test.frm'\nimport aspects (*) from 'C:/Test/Test.frm'");
    }

    @Override
    protected String getDirection() {
        return "from";
    }

    @Override
    protected void addOptionalParameters() {
        this.syntax.addModifier(new Modifier("NO LOAD", false));
        this.syntax.addModifier((AbstractModifier)new Modifier("GLOBAL", false).addParameter(new BooleanParameter("Global")));
        this.syntax.addModifier(new Modifier("ENABLE", false));
        this.syntax.addModifier(new Modifier("MODEL", false));
        this.syntax.addModifier((AbstractModifier)new Modifier("NAME", false).addParameter(new IdentifierParameter("NewName")));
        this.syntax.addModifier(new Modifier("FORCE", false));
        this.syntax.addModifier(new Modifier("NO OVERWRITE", false));
        super.addOptionalParameters();
    }

    @Override
    protected AbstractExportImportOperation.Definition completeDefinition(DSLStatement statement, AbstractExportImportOperation.Definition definition) throws ParsingException {
        if (statement.existsModifier("NO LOAD")) {
            if (definition.type != FrmEntityType.PACKAGE) {
                throw new ParsingException(this.getSyntaxErrorMessage("Parameter 'no load' is only applicable for Package type."));
            }
            definition.noLoad = true;
        }
        if (statement.existsModifier("GLOBAL")) {
            if (definition.type != FrmEntityType.PACKAGE && definition.type != FrmEntityType.SEMANTIC_TYPE) {
                throw new ParsingException(this.getSyntaxErrorMessage("Parameter 'global' is only applicable for Package or SDO types."));
            }
            definition.global = Boolean.parseBoolean(statement.getParameter("Global").getValue());
        } else if (statement.existsModifier("ENABLE")) {
            if (definition.type != FrmEntityType.JOB && definition.type != FrmEntityType.TASKLIST) {
                throw new ParsingException(this.getSyntaxErrorMessage("Parameter 'enable' is only applicable for Job or Tasklist types."));
            }
            definition.enable = true;
        } else if (statement.existsModifier("MODEL")) {
            if (definition.type != FrmEntityType.TASKLIST) {
                throw new ParsingException(this.getSyntaxErrorMessage("Parameter 'model' is only applicable for Tasklist type."));
            }
            definition.model = true;
        } else if (statement.existsModifier("NAME")) {
            if (definition.type != FrmEntityType.TASKLIST) {
                throw new ParsingException(this.getSyntaxErrorMessage("Parameter 'name' is only applicable for Tasklist type."));
            }
            definition.newName = statement.getParameter("NewName").getValue();
        }
        definition.force = statement.existsModifier("FORCE");
        definition.noOverwrite = statement.existsModifier("NO OVERWRITE");
        return super.completeDefinition(statement, definition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SLResponse doInvoke(AbstractExportImportOperation.Definition definition, MFSession session, long timeout) throws Exception {
        SLFileUtils file = (SLFileUtils)new SLFileUtilsFactory().create(session, definition.location);
        file.setVerbose(false);
        File frmDir = this.createTempDir();
        try {
            List<AbstractExportImportOperation.Artifact> artifacts;
            if (this.checkLocation(definition, file)) {
                this.raiseSLMessage("\nOpening FRM...\n", session);
                ImportOperation.extractFrmToTmpDir(frmDir, file);
                artifacts = this.getArtifactsFromFrmFile(frmDir, definition, session);
            } else {
                artifacts = this.getArtifactsFromSingleFile(frmDir, file, definition, session);
            }
            if (!artifacts.isEmpty()) {
                ImportOperation.importArtifacts(artifacts, frmDir, this, definition, session);
            } else {
                this.raiseSLMessage("\nNothing found.\n", session);
            }
        }
        finally {
            if (frmDir != null) {
                FileIOUtils.deleteFileDir(frmDir);
            }
        }
        return new SLResponse();
    }

    private List<AbstractExportImportOperation.Artifact> getArtifactsFromFrmFile(File frmDir, AbstractExportImportOperation.Definition definition, MFSession session) throws Exception {
        this.raiseSLMessage("\nSearching artifacts...\n", session);
        if (definition.type == FrmEntityType.SEMANTIC_TYPE) {
            return this.getTypeArtifactsFromTmpDir(definition, frmDir, session);
        }
        ArrayList<AbstractExportImportOperation.Artifact> result = new ArrayList<AbstractExportImportOperation.Artifact>();
        for (Map.Entry<String, List<String>> entry : definition.namespaceArtifactNames.entrySet()) {
            result.addAll(ImportOperation.getArtifactsFromTmpDir(definition.type, entry.getValue(), entry.getKey(), frmDir, session, ((RuntimeContext)this.callable).getXSerializer()));
        }
        return result;
    }

    public static void extractFrmToTmpDir(File frmDir, SLFileUtils frm) throws Exception {
        try (FrmFileReader reader = new FrmFileReader(ImportOperation.openInputStream(frm));){
            reader.extractTo(frmDir);
        }
    }

    public static List<AbstractExportImportOperation.Artifact> getArtifactsFromTmpDir(FrmEntityType type, List<String> names, String namespace, File frmDir, MFSession session, XSerializer serializer) throws Exception {
        ArrayList<AbstractExportImportOperation.Artifact> result = new ArrayList<AbstractExportImportOperation.Artifact>();
        File typeDir = new File(frmDir, type.getRelativePath());
        for (String name : ImportOperation.getArtifactNames(type, names, namespace, frmDir)) {
            AbstractExportImportOperation.PackageArtifact artifact = null;
            if (type == FrmEntityType.PACKAGE) {
                artifact = ImportOperation.getPackageArtifact(type, name, frmDir, session, false, serializer);
            } else if (type == FrmEntityType.SEMANTIC_TYPE) {
                artifactContent = ImportOperation.getArtifactContent(FrmEntityType.SEMANTIC_TYPE, name, typeDir);
                SemanticType semanticType = (SemanticType)serializer.deserialize(artifactContent.getData());
                artifact = ImportOperation.doGetArtifact(type, name, semanticType, session);
                artifact.setFile(artifactContent.getFile());
            } else if (type == FrmEntityType.EVENT_PROTOTYPE) {
                artifactContent = ImportOperation.getArtifactContent(FrmEntityType.EVENT_PROTOTYPE, name, typeDir);
                ImmutableEventDatagram eventDatagram = (ImmutableEventDatagram)serializer.deserialize(artifactContent.getData());
                artifact = ImportOperation.doGetArtifact(type, name, eventDatagram, session);
                artifact.setFile(artifactContent.getFile());
            } else {
                artifact = ImportOperation.getArtifact(type, name, typeDir, session);
            }
            result.add(artifact);
        }
        return result;
    }

    private static AbstractExportImportOperation.PackageArtifact getPackageArtifact(FrmEntityType type, String name, File frmDir, MFSession session, boolean skipTypes, XSerializer serializer) throws Exception {
        Map<String, SemanticType> semanticTypes;
        AbstractExportImportOperation.PackageArtifact result = (AbstractExportImportOperation.PackageArtifact)ImportOperation.getArtifact(type, name, new File(frmDir, type.getRelativePath()), session);
        result.setPackage((Package)serializer.deserialize(result.getData()));
        File jarsDir = new File(frmDir, FrmEntityType.ARCHIVE.getRelativePath());
        for (String jarName : result.pkg.listJARs()) {
            result.addJar((AbstractExportImportOperation.Artifact)ImportOperation.getArtifact(FrmEntityType.ARCHIVE, jarName, jarsDir, session));
        }
        if (!skipTypes && !(semanticTypes = ImportOperation.getTypes(frmDir, null, serializer)).isEmpty()) {
            for (AbstractExportImportOperation.Artifact jar : result.jars) {
                JarFile jarFile = new JarFile(jar.getFile());
                for (String className : jarFile.listEntries()) {
                    SemanticType semanticType = semanticTypes.get(MemoryJarFile.convertPathInJarToClassName(className));
                    if (semanticType == null) continue;
                    result.addSemanticType(ImportOperation.doGetTypeArtifact(semanticType, session));
                }
            }
        }
        return result;
    }

    private List<AbstractExportImportOperation.Artifact> getTypeArtifactsFromTmpDir(AbstractExportImportOperation.Definition definition, File frmDir, MFSession session) throws Exception {
        ArrayList<AbstractExportImportOperation.Artifact> result = new ArrayList<AbstractExportImportOperation.Artifact>();
        List<String> typeNames = definition.namespaceArtifactNames.get("");
        Map<String, SemanticType> types = definition.withAncestors && !ImportOperation.isWildcard(typeNames) ? this.getTypesWithAncestors(frmDir, typeNames, session) : ImportOperation.getTypes(frmDir, ImportOperation.getArtifactNames(definition.type, typeNames, null, frmDir), ((RuntimeContext)this.callable).getXSerializer());
        this.getTypeArtifactsFromSource(FrmEntityType.EXT_ARCHIVE, frmDir, types, artifactName -> {
            AbstractExportImportOperation.ExtArchiveArtifact jar = (AbstractExportImportOperation.ExtArchiveArtifact)ImportOperation.getArtifact(FrmEntityType.EXT_ARCHIVE, artifactName, FrmEntityType.EXT_ARCHIVE.getDirectory(frmDir), null);
            this.getTypeArtifactsFromJar(jar, jar, types, session, result);
        });
        this.getTypeArtifactsFromSource(FrmEntityType.PACKAGE, frmDir, types, artifactName -> {
            AbstractExportImportOperation.PackageArtifact pkg = ImportOperation.getPackageArtifact(FrmEntityType.PACKAGE, artifactName, frmDir, null, true, ((RuntimeContext)this.callable).getXSerializer());
            for (AbstractExportImportOperation.Artifact jar : pkg.jars) {
                this.getTypeArtifactsFromJar(jar, pkg, types, session, result);
            }
        });
        return result;
    }

    private Map<String, SemanticType> getTypesWithAncestors(File frmDir, List<String> typeNames, MFSession session) throws Exception {
        HashMap<String, SemanticType> result = new HashMap<String, SemanticType>();
        this.getTypesWithAncestors(new File(frmDir, FrmEntityType.SEMANTIC_TYPE.getRelativePath()), typeNames, session, result);
        return result;
    }

    private static Map<String, SemanticType> getTypes(File frmDir, List<String> typeNames, XSerializer serializer) throws Exception {
        HashMap<String, SemanticType> result = new HashMap<String, SemanticType>();
        File typesDir = new File(frmDir, FrmEntityType.SEMANTIC_TYPE.getRelativePath());
        for (String typeName : typeNames != null ? typeNames : ImportOperation.doGetArtifactNames(FrmEntityType.SEMANTIC_TYPE, null, frmDir)) {
            SemanticType type = ImportOperation.getSemanticType(typeName, typesDir, serializer);
            result.put(type.getClassName(), type);
        }
        return result;
    }

    private void getTypesWithAncestors(File typesDir, List<String> typeNames, MFSession session, Map<String, SemanticType> result) throws Exception {
        for (String typeName : typeNames) {
            ArrayList<SemanticType> typeWithAncestors = new ArrayList<SemanticType>();
            this.findTypeWithAncestors(typeName, typesDir, typeWithAncestors);
            if (typeWithAncestors.size() > 1) {
                this.raiseSLMessage("  Ancestors " + String.valueOf(typeWithAncestors.subList(1, typeWithAncestors.size()).stream().map(SemanticType::getTypeName).collect(Collectors.toList())) + " found for semantic type '" + typeName + "'.\n", session);
            }
            typeWithAncestors.forEach(type -> result.put(type.getClassName(), (SemanticType)type));
        }
    }

    private void findTypeWithAncestors(String typeName, File typesDir, List<SemanticType> result) throws Exception {
        File file = ImportOperation.getArtifactFile(FrmEntityType.SEMANTIC_TYPE, typeName, typesDir);
        if (file.exists()) {
            SemanticType type = ImportOperation.getSemanticType(typeName, typesDir, ((RuntimeContext)this.callable).getXSerializer());
            result.add(type);
            if (type.getAncestorType() != null) {
                this.findTypeWithAncestors(type.getAncestorType(), typesDir, result);
            }
        }
    }

    private static SemanticType getSemanticType(String typeName, File typesDir, XSerializer serializer) throws Exception {
        return (SemanticType)serializer.deserialize(ImportOperation.getArtifactContent(FrmEntityType.SEMANTIC_TYPE, typeName, typesDir).getData());
    }

    private void getTypeArtifactsFromSource(FrmEntityType sourceType, File frmDir, Map<String, SemanticType> types, AbstractExportImportOperation.Consumer<String> artifactsGetter) throws Exception {
        if (!types.isEmpty()) {
            for (String artifactName : ImportOperation.getArtifactNames(sourceType, null, null, frmDir)) {
                artifactsGetter.accept(artifactName);
                if (!types.isEmpty()) continue;
                break;
            }
        }
    }

    private void getTypeArtifactsFromJar(AbstractExportImportOperation.Artifact jar, AbstractExportImportOperation.ExtArchiveArtifact source, Map<String, SemanticType> types, MFSession session, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        boolean jarFound = false;
        JarFile jarFile = new JarFile(jar.getFile());
        for (Map.Entry<String, SemanticType> typeEntry : new ArrayList<Map.Entry<String, SemanticType>>(types.entrySet())) {
            if (jarFile.getEntry(MemoryJarFile.convertClassNameToEntryInJar(typeEntry.getKey())) != null) {
                SemanticType type = typeEntry.getValue();
                if (!jarFound) {
                    this.raiseSLMessage("  " + source.toCapitalizedString() + " found for semantic type '" + type.getTypeName() + "'.\n", session);
                    result.add(source);
                    jarFound = true;
                }
                source.addSemanticType(ImportOperation.doGetTypeArtifact(type, session));
                types.remove(typeEntry.getKey());
            }
            if (!types.isEmpty()) continue;
            break;
        }
    }

    private static AbstractExportImportOperation.TypeArtifact doGetTypeArtifact(SemanticType type, MFSession session) throws Exception {
        return (AbstractExportImportOperation.TypeArtifact)ImportOperation.doGetArtifact(FrmEntityType.SEMANTIC_TYPE, type.getTypeName(), type, session);
    }

    private static List<String> getArtifactNames(FrmEntityType type, List<String> names, String namespace, File frmDir) throws Exception {
        return ImportOperation.doGetNames(type, names, () -> ImportOperation.doGetArtifactNames(type, namespace, frmDir));
    }

    private static <T extends AbstractExportImportOperation.Artifact> T getArtifact(FrmEntityType type, String name, File fromDir, MFSession session) throws Exception {
        AbstractExportImportOperation.Artifact artifact = ImportOperation.getArtifactContent(type, name, fromDir);
        T result = ImportOperation.doGetArtifact(type, name, null, session);
        ((AbstractExportImportOperation.Artifact)result).setFile(artifact.getFile());
        return result;
    }

    private static <T extends AbstractExportImportOperation.Artifact, TData> T doGetArtifact(FrmEntityType type, String name, TData data, MFSession session) throws Exception {
        AbstractExportImportOperation.Artifact result = type == FrmEntityType.ARCHIVE ? new AbstractExportImportOperation.Artifact(type, name, (File)data) : (type == FrmEntityType.EXT_ARCHIVE ? new AbstractExportImportOperation.ExtArchiveArtifact(type, name, (File)data) : (type == FrmEntityType.PACKAGE ? new AbstractExportImportOperation.PackageArtifact(type, name, (byte[])data) : (type == FrmEntityType.SEMANTIC_TYPE ? new AbstractExportImportOperation.TypeArtifact(type, name, (SemanticType)data) : (type == FrmEntityType.EVENT_PROTOTYPE ? new AbstractExportImportOperation.EventPrototypeArtifact(type, name, (ImmutableEventDatagram)data, null) : (type == FrmEntityType.TASKLIST ? new AbstractExportImportOperation.TaskListArtifact(name, (byte[])data) : new AbstractExportImportOperation.Artifact(type, name, (byte[])data))))));
        if (session != null) {
            ImportOperation.raiseSLMessage(new SLMessage("  " + result.toCapitalizedString() + " found.\n", session));
        }
        return (T)result;
    }

    private static AbstractExportImportOperation.Artifact getArtifactContent(FrmEntityType type, String name, File fromDir) throws Exception {
        try {
            File file = ImportOperation.getArtifactFile(type, name, fromDir);
            if (!file.exists()) {
                throw new Exception("Artifact with file name " + String.valueOf(file) + " does not exist.");
            }
            return new AbstractExportImportOperation.Artifact(type, name, file);
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException || exception.getCause() instanceof FileNotFoundException) {
                throw new Exception(AbstractExportImportOperation.Artifact.toCapitalizedString(type, name) + " not found.");
            }
            throw new Exception("Obtaining content of " + AbstractExportImportOperation.Artifact.toCapitalizedString(type, name) + " failed.", exception);
        }
    }

    private List<AbstractExportImportOperation.Artifact> getArtifactsFromSingleFile(File frmDir, SLFileUtils remoteDir, AbstractExportImportOperation.Definition definition, MFSession session) throws Exception {
        this.raiseSLMessage("\nSearching artifacts...\n", session);
        ArrayList<AbstractExportImportOperation.Artifact> result = new ArrayList<AbstractExportImportOperation.Artifact>();
        List<String> artifactNames = this.getArtifactNames(definition, remoteDir);
        if (!artifactNames.isEmpty()) {
            for (String artifactName : artifactNames) {
                File artifactFile = new File(frmDir, artifactName);
                try (FileOutputStream stream = new FileOutputStream(artifactFile);){
                    remoteDir.readFile(ImportOperation.getArtifactFile(definition.type, artifactName, new File(remoteDir.getFilename())).getAbsolutePath(), stream);
                    result.add((AbstractExportImportOperation.Artifact)ImportOperation.doGetArtifact(definition.type, artifactName, artifactFile, session));
                }
            }
        }
        return result;
    }

    private List<String> getArtifactNames(AbstractExportImportOperation.Definition definition, SLFileUtils dir) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : definition.namespaceArtifactNames.entrySet()) {
            result.addAll(ImportOperation.doGetNames(definition.type, entry.getValue(), () -> dir.listDirectory().stream().filter(file -> file.endsWith(definition.type.getExtension())).collect(Collectors.toList())));
        }
        return result;
    }

    private static List<String> doGetArtifactNames(FrmEntityType type, String namespace, File frmDir) throws Exception {
        File dir = new File(frmDir, type.getRelativePath());
        if (!dir.exists()) {
            return new ArrayList<String>();
        }
        if (type == FrmEntityType.EVENT_PROTOTYPE) {
            return ImportOperation.listEventPrototypeFiles(dir);
        }
        if (type == FrmEntityType.MLCACHE) {
            return ImportOperation.listMlcache(dir);
        }
        if (type == FrmEntityType.OBJECT) {
            return ImportOperation.listObjects(dir, namespace);
        }
        return Arrays.stream(FileIOUtils.directoryList(dir.getAbsolutePath(), type.getExtension())).map(file -> type.stripExtension(file.getName())).collect(Collectors.toList());
    }

    private static List<String> doGetNames(FrmEntityType type, List<String> names, Callable<List<String>> namesGetter) throws Exception {
        if (names == null || ImportOperation.isWildcard(names)) {
            return namesGetter.call();
        }
        if (type == FrmEntityType.TASKLIST) {
            return ImportOperation.doGetTaskListNames(names, namesGetter.call());
        }
        if (type == FrmEntityType.EVENT_PROTOTYPE) {
            return ImportOperation.doGetEventPrototypeNames(names, namesGetter.call());
        }
        if (type == FrmEntityType.MLCACHE) {
            return ImportOperation.doListMlcache(names, namesGetter.call());
        }
        if (type == FrmEntityType.OBJECT) {
            return ImportOperation.doListObjects(names, namesGetter.call());
        }
        return names;
    }

    private static List<String> doGetEventPrototypeNames(List<String> names, List<String> fileNames) {
        return fileNames.stream().filter(fileName -> names.contains(fileName) || names.contains(FrmFileWriter.convertFrmEntity(FrmEntityType.EVENT_PROTOTYPE, new FrmEntity(fileName.substring(fileName.lastIndexOf(47) + 1), "")).getName())).collect(Collectors.toList());
    }

    private static List<String> doGetTaskListNames(List<String> names, List<String> fileNames) throws Exception {
        return fileNames.stream().filter(fileName -> names.contains(AbstractExportImportOperation.TaskListArtifact.extractName(fileName))).collect(Collectors.toList());
    }

    private static File getArtifactFile(FrmEntityType type, String name, File dir) {
        return new File(dir, ImportOperation.getFilename(type, name));
    }

    public static void importArtifacts(List<AbstractExportImportOperation.Artifact> artifacts, File frmDir, AbstractDSLOperation<RuntimeContext> operation, AbstractExportImportOperation.Definition definition, MFSession session) throws Exception {
        ImportOperation.raiseSLMessage(new SLMessage("\nAdding artifacts to node...\n", session));
        for (AbstractExportImportOperation.Artifact artifact : artifacts) {
            ImportOperation.importArtifact(artifact, frmDir, operation, definition, session);
        }
    }

    private static void importArtifact(AbstractExportImportOperation.Artifact artifact, File frmDir, AbstractDSLOperation<RuntimeContext> operation, AbstractExportImportOperation.Definition definition, MFSession session) throws Exception {
        final RuntimeContext callable = operation.callable();
        Object targetPath = definition.targetPath;
        if (targetPath == null) {
            ImportOperation.raiseSLMessage(new SLMessage("  Adding " + String.valueOf(artifact) + "...\n", session));
        } else {
            targetPath = (String)targetPath + "/" + new File(artifact.getArchiveEntryName()).getName();
            targetPath = ((String)targetPath).replace("//", "/");
            ImportOperation.raiseSLMessage(new SLMessage("  Adding " + String.valueOf(artifact) + " to " + (String)targetPath + "...\n", session));
        }
        final RepositoryAccessor repository = callable.getRepositoryAccessor();
        switch (artifact.type) {
            case ARCHIVE: {
                if (repository.existsArchive(artifact.name)) {
                    repository.removeArchive(artifact.name);
                }
                repository.addArchive(artifact.getFile());
                break;
            }
            case EXT_ARCHIVE: {
                ImportOperation.removeOldSemanticTypes(artifact, callable);
                if (repository.existsExtensionArchive(artifact.name)) {
                    repository.removeExtensionArchive(artifact.name, definition.force);
                }
                repository.addExtensionArchive(artifact.getFile());
                ImportOperation.addSemanticTypes(artifact, session, callable);
                break;
            }
            case SERVICE: {
                ImportOperation.doImportArtifact(artifact, new Importer(){

                    @Override
                    void doRemoveOldArtifact(String name, String type) throws Exception {
                        if (repository.existsServiceConfiguration(name, type)) {
                            repository.removeServiceConfiguration(name, type);
                        }
                    }

                    @Override
                    void doImportNewArtifact(String fromDir, String name, String type) throws Exception {
                        repository.importServiceConfiguration(fromDir, name, type, true);
                    }
                });
                break;
            }
            case JDBC_FACTORY: {
                ImportOperation.doImportArtifact(artifact, new Importer(){

                    @Override
                    void doRemoveOldArtifact(String name, String type) throws Exception {
                        if (repository.existsJDBCFactory(name, type)) {
                            repository.removeJDBCFactory(name, type);
                        }
                    }

                    @Override
                    void doImportNewArtifact(String fromDir, String name, String type) throws Exception {
                        repository.importJDBCFactory(fromDir, name, type);
                    }
                });
                break;
            }
            case CLIENT_FACTORY: {
                ImportOperation.doImportArtifact(artifact, new Importer(){

                    @Override
                    void doRemoveOldArtifact(String name, String type) throws Exception {
                        if (repository.existsClientFactory(name, type)) {
                            repository.removeClientFactory(name, type);
                        }
                    }

                    @Override
                    void doImportNewArtifact(String fromDir, String name, String type) throws Exception {
                        repository.importClientFactory(fromDir, name, type);
                    }
                });
                break;
            }
            case TRANSPORT_FACTORY: {
                ImportOperation.doImportArtifact(artifact, new Importer(){

                    @Override
                    void doRemoveOldArtifact(String name, String type) throws Exception {
                        if (repository.existsTransportFactory(name, type)) {
                            repository.removeTransportFactory(name, type);
                        }
                    }

                    @Override
                    void doImportNewArtifact(String fromDir, String name, String type) throws Exception {
                        repository.importTransportFactory(fromDir, name, type);
                    }
                });
                break;
            }
            case PACKAGE: {
                ImportOperation.removeOldSemanticTypes(artifact, callable);
                RuntimeManifestManager manifestManager = callable.getPackageManifestManager();
                if (callable.getPackageManifestManager().existsPackage(artifact.name)) {
                    if (manifestManager.isPackageLoaded(artifact.name)) {
                        manifestManager.unloadPackage(artifact.name);
                    }
                    manifestManager.removePackage(artifact.name);
                }
                if (repository.existsPackage(artifact.name)) {
                    repository.removePackage(artifact.name, true);
                }
                AbstractExportImportOperation.PackageArtifact pkgArtifact = (AbstractExportImportOperation.PackageArtifact)artifact;
                if (definition.global != null) {
                    ImportOperation.setGlobal(pkgArtifact.pkg, definition.global);
                }
                repository.addPackage(pkgArtifact.pkg, (File[])pkgArtifact.jars.stream().map(AbstractExportImportOperation.Artifact::getFile).toArray(File[]::new));
                if (definition.noLoad) break;
                manifestManager.addPackage(PackageDescriptor.create(pkgArtifact.pkg, true, definition.global));
                ImportOperation.addSemanticTypes(pkgArtifact, session, callable);
                break;
            }
            case FILE_DESCRIPTOR: {
                ImportOperation.doImportArtifact(artifact, new Importer(){

                    @Override
                    void doRemoveOldArtifact(String name, String type) throws Exception {
                        if (FileDescriptorRepositoryUtils.existsFileDescriptor(name)) {
                            FileDescriptorRepositoryUtils.removeFileDescriptor(name);
                        }
                    }

                    @Override
                    void doImportNewArtifact(String fromDir, String name, String type1) throws Exception {
                        byte[] bytes = FileIOUtils.getFile(fromDir, FileDescriptor.class.getSimpleName() + "." + name + FrmEntityType.FILE_DESCRIPTOR.getExtension());
                        FileDescriptor descriptor = (FileDescriptor)callable.getXSerializerFactory().getDefaultSerializer().deserialize(bytes);
                        FileDescriptorRepositoryUtils.saveFileDescriptor(name, descriptor);
                    }
                });
                break;
            }
            case SEMANTIC_TYPE: {
                SemanticType semanticType = ((AbstractExportImportOperation.TypeArtifact)artifact).semanticType;
                if (callable.getSemanticTypeCache().existsSemanticType(semanticType.getTypeName())) {
                    callable.getSemanticTypeFactory().removeSemanticType(semanticType.getTypeName(), true);
                }
                callable.getSemanticTypeFactory().addSemanticType(semanticType);
                break;
            }
            case EVENT_PROTOTYPE: {
                ImmutableEventDatagram eventDatagram = ((AbstractExportImportOperation.EventPrototypeArtifact)artifact).eventDatagram;
                if (callable.getDatagramPrototypeCache().existsEventId(eventDatagram.getEventId()) && definition.noOverwrite) {
                    ImportOperation.raiseSLMessage(new SLMessage("    Skipped, already exists.\n", session));
                    break;
                }
                if (callable.getDatagramPrototypeCache().existsEventId(eventDatagram.getEventId())) {
                    callable.getDatagramPrototypeFactory().removeEventPrototype(eventDatagram.getEventId());
                }
                if (eventDatagram instanceof AdvisoryEvent) {
                    PrototypeFactory.addAdvisoryPrototype(eventDatagram.getEventId(), (AdvisoryEventDatagram)eventDatagram);
                    break;
                }
                if (eventDatagram instanceof ExceptionEvent) {
                    PrototypeFactory.addExceptionPrototype(eventDatagram.getEventId(), (ExceptionEventDatagram)eventDatagram);
                    break;
                }
                if (eventDatagram.getClass().equals(DataEvent.class)) {
                    PrototypeFactory.addDataEventPrototype(eventDatagram.getEventId(), (DataEvent)eventDatagram);
                    break;
                }
                if (eventDatagram.getClass().equals(DeltaEvent.class)) {
                    PrototypeFactory.addDeltaEventPrototype(eventDatagram.getEventId(), (DeltaEvent)eventDatagram);
                    break;
                }
                if (eventDatagram instanceof OpaqueDatagram) {
                    PrototypeFactory.addOpaqueEventPrototype(eventDatagram.getEventId(), (OpaqueEvent)eventDatagram);
                    break;
                }
                PrototypeFactory.addEventPrototype(eventDatagram.getEventId(), (EventDatagram)eventDatagram);
                break;
            }
            case JOB: {
                Scheduler scheduler;
                ScheduledJob job = (ScheduledJob)callable.getXSerializer().deserialize(artifact.getData());
                AbstractExportImportOperation.Artifact tlArtifact = null;
                AbstractExecutableObject taskList = null;
                if (job.getTaskListOID() != null) {
                    String tlOID = job.getTaskListOID().toString();
                    String artifactName = ImportOperation.doGetArtifactNames(FrmEntityType.TASKLIST, null, frmDir).stream().filter(name -> name.endsWith(tlOID)).findFirst().orElse(null);
                    if (artifactName != null && (tlArtifact = (AbstractExportImportOperation.Artifact)ImportOperation.getArtifact(FrmEntityType.TASKLIST, artifactName, new File(frmDir, FrmEntityType.TASKLIST.getRelativePath()), null)) != null) {
                        taskList = (TaskList)callable.getXSerializer().deserialize(tlArtifact.getData());
                        ImportOperation.raiseSLMessage(new SLMessage("  Task list '" + taskList.getName() + "' found for job '" + job.getName() + "'.\n", session));
                    }
                }
                if ((scheduler = ImportOperation.getScheduler((AbstractRuntimeContext)callable, session)).existsJob(job.getName())) {
                    scheduler.disableJob(job.getName());
                    scheduler.dropJob(job.getName());
                }
                scheduler.createJob(job.getName(), job);
                if (taskList != null) {
                    ImportOperation.raiseSLMessage(new SLMessage("  Adding " + String.valueOf(tlArtifact) + "...\n", session));
                    ImportOperation.doCreateTaskList(session, scheduler, taskList, null, definition.enable);
                    scheduler.setJobTaskList(job.getName(), taskList.getName());
                }
                if (!definition.enable) break;
                ImportOperation.raiseSLMessage(new SLMessage("  Enabling " + String.valueOf(artifact) + "...\n", session));
                scheduler.enableJob(job.getName());
                break;
            }
            case TASKLIST: {
                ImportOperation.doCreateTaskList(operation, session, ImportOperation.getScheduler((AbstractRuntimeContext)callable, session), (TaskList)callable.getXSerializer().deserialize(artifact.getData()), definition.enable, definition.model, definition.newName);
                break;
            }
            case MLCACHE: {
                File localModelFile = new File(artifact.type.getRelativePath(), artifact.name);
                if (localModelFile.exists() && !definition.force) {
                    SLOperationLogger.log(ImportOperation.class, " WARNING: File " + localModelFile.toString() + " already exists. Remove it first or specify FORCE option.\n");
                    break;
                }
                new File(localModelFile.getParent()).mkdirs();
                try (InputStream inputStream = Files.newInputStream(artifact.getFile().toPath(), new OpenOption[0]);
                     OutputStream outputStream = Files.newOutputStream(localModelFile.toPath(), new OpenOption[0]);){
                    FileIOUtils.copy(inputStream, outputStream);
                    break;
                }
            }
            case FACETS: 
            case ASPECTS: {
                try (Connection connection = callable.getDataspaceManager().getJDBCConnection("SYS", session.getOwner().getSecurityContext());){
                    Statement stat = connection.createStatement();
                    String sql = new String(artifact.getData());
                    stat.execute(sql);
                    break;
                }
            }
            case OBJECT: {
                String filename;
                String name2;
                String namespace = new File(artifact.name).getParentFile().getPath();
                if (targetPath != null) {
                    namespace = new File((String)targetPath).getParentFile().getPath();
                }
                if ((name2 = (filename = new File(artifact.name).getName())).endsWith(".xdo")) {
                    name2 = name2.substring(0, name2.length() - 4);
                }
                if (name2.contains(".")) {
                    name2 = name2.substring(name2.indexOf(".") + 1);
                }
                if (RepositoryUtils.existsObject(namespace, name2)) {
                    RepositoryUtils.unbindObject(namespace, name2);
                }
                byte[] bytes = FileIOUtils.getFile(artifact.getFile().getParentFile().getAbsolutePath(), filename);
                Object object = callable.getXSerializerFactory().getDefaultSerializer().deserialize(bytes);
                RepositoryUtils.bindObject(namespace, name2, object);
                break;
            }
        }
    }

    private static void doImportArtifact(AbstractExportImportOperation.Artifact artifact, Importer importer) throws Exception {
        Prototype prototype = Prototype.parseName(artifact.name, false);
        importer.removeOldArtifact(prototype);
        importer.importNewArtifact(artifact.getFile().getParentFile().getAbsolutePath(), prototype);
    }

    private static void removeOldSemanticTypes(AbstractExportImportOperation.Artifact artifact, RuntimeContext callable) throws Exception {
        for (AbstractExportImportOperation.TypeArtifact typeArtifact : ((AbstractExportImportOperation.ExtArchiveArtifact)artifact).types) {
            if (!callable.getSemanticTypeCache().existsSemanticType(typeArtifact.semanticType.getTypeName())) continue;
            callable.getSemanticTypeFactory().removeSemanticType(typeArtifact.semanticType.getTypeName(), true);
        }
    }

    private static void addSemanticTypes(AbstractExportImportOperation.Artifact artifact, MFSession session, RuntimeContext callable) throws Exception {
        for (AbstractExportImportOperation.TypeArtifact typeArtifact : ((AbstractExportImportOperation.ExtArchiveArtifact)artifact).types) {
            ImportOperation.raiseSLMessage(new SLMessage("  Adding " + String.valueOf(typeArtifact) + "...\n", session));
            callable.getSemanticTypeFactory().addSemanticType(typeArtifact.semanticType);
        }
    }

    private static void doCreateTaskList(MFSession session, Scheduler scheduler, TaskList taskList, String newName, boolean enable) throws Exception {
        String listName = taskList.getName();
        ImportOperation.dropExistingTaskList(scheduler, listName);
        if (newName != null) {
            listName = newName;
        }
        scheduler.createTaskList(listName, taskList);
        ImportOperation.enableTaskList(scheduler, session, listName, enable);
    }

    private static void doCreateTaskList(AbstractDSLOperation<RuntimeContext> operation, MFSession session, Scheduler scheduler, TaskList taskList, boolean enable, boolean model, String newName) throws Exception {
        if (taskList.isModel().booleanValue()) {
            String listName = taskList.getName();
            if (model) {
                if (enable) {
                    throw new Exception(operation.getSyntaxErrorMessage("Parameter 'enable' is not applicable for importing Task List Model."));
                }
                if (newName != null) {
                    listName = newName;
                }
                if (scheduler.existsTaskList(listName)) {
                    throw new SchedulerException(6136, "Task List '" + listName + "' already exists.");
                }
            } else {
                if (newName == null) {
                    throw new SchedulerException(6151, "New name must be specified for Task List imported from Model.");
                }
                listName = newName;
                ImportOperation.dropExistingTaskList(scheduler, listName);
            }
            scheduler.createTaskList(listName, taskList, model);
            ImportOperation.enableTaskList(scheduler, session, listName, !model);
        } else {
            if (model) {
                throw new ParsingException(operation.getSyntaxErrorMessage("Parameter 'model' is only applicable for importing Task List Model."));
            }
            if (newName != null) {
                throw new ParsingException(operation.getSyntaxErrorMessage("Parameter 'newName' is only applicable for importing Task List Model."));
            }
            ImportOperation.doCreateTaskList(session, scheduler, taskList, newName, enable);
        }
    }

    private static void dropExistingTaskList(Scheduler scheduler, String listName) throws Exception {
        if (scheduler.existsTaskList(listName)) {
            scheduler.disableTaskList(listName);
            scheduler.dropTaskList(listName);
        }
    }

    private static void enableTaskList(Scheduler scheduler, MFSession session, String listName, boolean enable) throws Exception {
        if (enable) {
            scheduler.enableTaskList(listName);
            ImportOperation.raiseSLMessage(new SLMessage("  Enabling Task List '" + listName + "'...\n", session));
        }
    }

    public static List<String> listEventPrototypeFiles(File dir) {
        return Arrays.stream(new String[]{"AdvisoryDatagramFactory", "EventDatagramFactory", "ExceptionDatagramFactory", "OpaqueDatagramFactory"}).flatMap(d -> Arrays.stream(Optional.ofNullable(new File(dir, (String)d).list()).orElse(new String[0])).map(n -> d + "/" + n)).collect(Collectors.toList());
    }

    public static String convertEventPrototypeFileToId(String filename) {
        if (filename.endsWith(".xdo")) {
            if ((filename = filename.substring(0, filename.length() - ".xdo".length())).contains(File.separator)) {
                filename = filename.substring(filename.indexOf(File.separator) + 1);
            }
            if (filename.contains(".")) {
                filename = filename.substring(filename.indexOf(".") + 1);
                filename = filename.replace("_", ".");
            }
        }
        return filename;
    }

    private static abstract class Importer {
        private Importer() {
        }

        void removeOldArtifact(Prototype prototype) throws Exception {
            this.doRemoveOldArtifact(prototype.getInstanceName(), prototype.getModelName());
        }

        abstract void doRemoveOldArtifact(String var1, String var2) throws Exception;

        void importNewArtifact(String fromDir, Prototype prototype) throws Exception {
            this.doImportNewArtifact(fromDir, prototype.getInstanceName(), prototype.getModelName());
        }

        abstract void doImportNewArtifact(String var1, String var2, String var3) throws Exception;
    }
}

