/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.repository;

import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorRepositoryUtils;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.runtime.mf.operation.frm.FrmFileReader;
import com.streamscape.runtime.mf.operation.frm.FrmFileWriter;
import com.streamscape.runtime.mf.operation.repository.ImportOperation;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.dispatcher.AbstractExportImportOperation;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.utils.RepositoryUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.AbstractDSLOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExportOperation
extends AbstractExportImportOperation {
    public static final String NAME = "export";

    public ExportOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setDescription("Exports the specified artifacts from the current node to the specified location.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   <ArtifactType> - Type of the artifact.\n   <ArtifactName> - Name of the artifact.\n                    Value * means that all suitable artifacts found in the node will be exported.\n\n   The following artifact types are supported:\n\n      client-factory  - Client Connection Factory Object. Stored in 'clients' area of Repository. Name format is <FactoryType>.<FactoryName>.\n      db-factory      - DB Connection Factory Object. Stored in 'jdbc' area of Repository. Name format is <FactoryType>.<FactoryName>.\n      msg-factory     - Message Connection Factory Object. Stored in 'transports' area of Repository. Name format is <FactoryType>.<FactoryName>.\n      service         - Service Configuration Object. Stored in 'service' area of Repository. Name format is <ServiceType>.<ServiceName>.\n      package         - Package Object. Stored in 'pkg' area of Repository. Name format is <PackageType>.<PackageName>.\n                        Package is exported with all its archives.\n                        All semantic types related to this package are also exported (i.e. types whose classes belong to the package).\n      archive         - Archive (JAR file). Stored in 'lib' area of Repository. Name format is <ArchiveName>.jar.\n      ext-archive     - Extension archive (JAR file). Stored in 'ext' area of Repository. Name format is <ArchiveName>.jar.\n      sdo             - Semantic Type (SDO). Stored in 'types' area of Repository. Name format is <TypeName>.\n                        Semantic type is exported with a related package or extension archive where the type's class is located.\n      file-descriptor - File Descriptor. Stored in 'objects/file/descriptor' area of Repository. Name format is FileDescriptor.<FileName>.\n      event-prototype - Event Prototype. Stored in 'objects/sys/datagram/prototype' area of Repository. Name format is <EventId>.\n      job             - Scheduler Job. Name format is <JobName>.\n                        Job is exported with its Task List if exists.\n      tasklist        - Scheduler Task List. Name format is <ListName>.\n      mlcache         - Models, dictionaries and stop words for NLP services. Name format is <ServiceName> or <ModelName> or <ServiceName>/<ModelName>.\n      object          - Any object from .tfcache/objects directory.\n\n   to <Location>  - Path to the location where the artifacts will be exported.\n                    Location must point to FRM file (existing or not) for all artifact types, except archive and ext-archive.\n                    For archives the location can also point to an existing directory.\n                    If the location points to an existing FRM file, the artifacts will be added to this file (and replace the existing artifacts).\n\nOptional parameters:\n\n   with ancestors - Exports semantic types with all their ancestors.\n                    This parameter is applicable for SDO artifacts only.\n   with wait      - Executes this operation in synchronous mode (waits until completion or reply timeout expiration).");
        this.syntax.setExamples("export client-factory (FTPClient.Test.cfo) to 'C:/Test/Test.frm'\nexport db-factory (SQLServer.Test1, SQLServer.Test2) to 'C:/Test/Test.frm'\nexport service (TestService.Test) to 'C:/Test/Test.frm'\nexport package (sdo.Test, sdo.Test1) to 'C:/Test/Test.frm'\nexport archive (employee.jar) to 'C:/Test/Test.frm'\nexport archive (employee.jar) to 'C:/Test'\nexport ext-archive (mail.jar) to 'C:/Test/Test.frm'\nexport ext-archive (*) to 'C:/Test'\nexport sdo (Employee, Department) to 'C:/Test/Test.frm'\nexport sdo (Employee) from 'C:/Test/Test.frm' with ancestors\nexport sdo (*) to 'C:/Test/Test.frm'\nexport event-prototype (my.event) to 'C:/Test/Test.frm'\nexport file-descriptor (FileDescriptor.User) to 'C:/Test/Test.frm'\nexport file-descriptor (*) to 'C:/Test/Test.frm'\nexport job (Test) to 'C:/Test/Test.frm'\nexport tasklist (*) to 'C:/Test/Test.frm'\nexport mlcache (*) to 'C:/Test/Test.frm'\nexport mlcache (TXCluster, CTExtractor/en-ner-location.bin.mlm) to 'C:/Test/Test.frm'\nexport object (http/request/MyDataspace/MyServer/*) to './my_frm.frm'\nexport object (http/request/MyDataspace/MyServer/HttpRequest.MyRequest.xdo) to './my_frm.frm'\nexport object (http/request/MyDataspace/MyServer/*) (http/request/MyDataspace/AnotherServer/) './my_frm.frm'\nexport object (http/request/MyDataspace/MyServer/HTTPRequest.request1.xdo, http/request/MyDataspace/MyServer/HTTPRequest.request2.xdo) './my_frm.frm'\nexport facets (Skills) to './my_frm.frm'\nexport aspects (*) to './my_frm.frm'\n");
    }

    @Override
    protected String getDirection() {
        return "to";
    }

    @Override
    protected SLResponse doInvoke(AbstractExportImportOperation.Definition definition, MFSession session, long timeout) throws Exception {
        SLFileUtils file = (SLFileUtils)new SLFileUtilsFactory().create(session, definition.location);
        file.setVerbose(false);
        this.checkLocation(definition, file);
        this.raiseSLMessage("\nSearching artifacts...\n", session);
        List<AbstractExportImportOperation.Artifact> artifacts = this.getArtifacts(definition, session);
        this.raiseSLMessage("\n", session);
        if (!artifacts.isEmpty()) {
            this.exportArtifacts(definition, session, file, artifacts);
        } else {
            this.raiseSLMessage("Nothing found.\n", session);
        }
        return new SLResponse();
    }

    private List<AbstractExportImportOperation.Artifact> getArtifacts(AbstractExportImportOperation.Definition definition, MFSession session) throws Exception {
        ArrayList<AbstractExportImportOperation.Artifact> result = new ArrayList<AbstractExportImportOperation.Artifact>();
        HashSet<String> foundSources = null;
        if (definition.type == FrmEntityType.SEMANTIC_TYPE) {
            foundSources = new HashSet<String>();
        }
        for (String artifactName : this.getArtifactNames(definition, session)) {
            AbstractExportImportOperation.Artifact artifact = null;
            switch (definition.type) {
                case ARCHIVE: {
                    artifact = this.getArchiveArtifact(definition.type, artifactName, result);
                    break;
                }
                case EXT_ARCHIVE: {
                    artifact = this.getExtArchiveArtifact(definition.type, artifactName, result);
                    break;
                }
                case PACKAGE: {
                    artifact = this.getPackageArtifact(definition.type, artifactName, session, result);
                    break;
                }
                case SEMANTIC_TYPE: {
                    artifact = this.getTypeArtifact(definition.type, artifactName, foundSources, session, result);
                    break;
                }
                case EVENT_PROTOTYPE: {
                    artifact = this.getEventPrototypeArtifact(definition.type, artifactName, session, result);
                    break;
                }
                case SERVICE: {
                    artifact = new ArtifactGetter(definition.type, artifactName){

                        @Override
                        void exportArtifact(String path, String name, String type) throws Exception {
                            ((RuntimeContext)ExportOperation.this.callable).getRepositoryAccessor().exportServiceConfiguration(path, name, type);
                        }

                        @Override
                        boolean doCheckExistence(String name, String type) throws Exception {
                            return ((RuntimeContext)ExportOperation.this.callable).getRepositoryAccessor().existsServiceConfiguration(name, type);
                        }
                    }.execute(result);
                    break;
                }
                case JDBC_FACTORY: {
                    artifact = new ArtifactGetter(definition.type, artifactName){

                        @Override
                        void exportArtifact(String path, String name, String type) throws Exception {
                            ((RuntimeContext)ExportOperation.this.callable).getRepositoryAccessor().exportJDBCFactory(path, name, type);
                        }

                        @Override
                        boolean doCheckExistence(String name, String type) throws Exception {
                            return ((RuntimeContext)ExportOperation.this.callable).getRepositoryAccessor().existsJDBCFactory(name, type);
                        }
                    }.execute(result);
                    break;
                }
                case CLIENT_FACTORY: {
                    artifact = new ArtifactGetter(definition.type, artifactName){

                        @Override
                        void exportArtifact(String path, String name, String type) throws Exception {
                            ((RuntimeContext)ExportOperation.this.callable).getRepositoryAccessor().exportClientFactory(path, name, type);
                        }

                        @Override
                        boolean doCheckExistence(String name, String type) throws Exception {
                            return ((RuntimeContext)ExportOperation.this.callable).getRepositoryAccessor().existsClientFactory(name, type);
                        }
                    }.execute(result);
                    break;
                }
                case TRANSPORT_FACTORY: {
                    artifact = new ArtifactGetter(definition.type, artifactName){

                        @Override
                        void exportArtifact(String path, String name, String type) throws Exception {
                            ((RuntimeContext)ExportOperation.this.callable).getRepositoryAccessor().exportTransportFactory(path, name, type);
                        }

                        @Override
                        boolean doCheckExistence(String name, String type) throws Exception {
                            return ((RuntimeContext)ExportOperation.this.callable).getRepositoryAccessor().existsTransportFactory(name, type);
                        }
                    }.execute(result);
                    break;
                }
                case FILE_DESCRIPTOR: {
                    artifact = new ArtifactGetter(definition.type, artifactName){

                        @Override
                        void exportArtifact(String workingDir, String name, String type1) throws Exception {
                            FileDescriptor descriptor = FileDescriptorRepositoryUtils.lookupFileDescriptor(name);
                            byte[] bytes = ((RuntimeContext)ExportOperation.this.callable).getXSerializerFactory().getDefaultSerializer().serialize(descriptor).getBytes();
                            File exportFile = new File(workingDir, FileDescriptor.class.getSimpleName() + "." + name + this.type.getExtension());
                            if (exportFile.exists()) {
                                throw new RepositoryException(4029, "File '" + exportFile.getAbsolutePath() + "' already exists.");
                            }
                            FileIOUtils.putFile(workingDir, exportFile.getName(), bytes);
                        }

                        @Override
                        boolean doCheckExistence(String name, String type) throws Exception {
                            return FileDescriptorRepositoryUtils.existsFileDescriptor(name);
                        }
                    }.execute(result);
                    break;
                }
                case JOB: {
                    artifact = this.getJobArtifact(definition.type, artifactName, session, result);
                    break;
                }
                case TASKLIST: {
                    artifact = this.getTaskListArtifact(definition.type, artifactName, session, result);
                    break;
                }
                case MLCACHE: {
                    artifact = this.getMlcacheArtifact(definition.type, artifactName, result);
                    break;
                }
                case FACETS: {
                    artifact = this.getFacetsArtifact(definition.type, artifactName, result);
                    break;
                }
                case ASPECTS: {
                    artifact = this.getAspectsArtifact(definition.type, artifactName, result);
                    break;
                }
                case OBJECT: {
                    artifact = this.getObjectArtifact(definition.type, artifactName, result);
                }
            }
            if (artifact == null) continue;
            this.raiseSLMessage("  " + artifact.toCapitalizedString() + " found.\n", session);
        }
        return result;
    }

    private List<String> getArtifactNames(AbstractExportImportOperation.Definition definition, MFSession session) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : definition.namespaceArtifactNames.entrySet()) {
            result.addAll(this.getArtifactNames(definition, session, entry.getValue(), entry.getKey()));
        }
        return result;
    }

    private List<String> getArtifactNames(AbstractExportImportOperation.Definition definition, MFSession session, List<String> artifactNames, String namespace) throws Exception {
        if (ExportOperation.isWildcard(artifactNames)) {
            RepositoryAccessor accessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
            switch (definition.type) {
                case ARCHIVE: {
                    return accessor.listArchives();
                }
                case EXT_ARCHIVE: {
                    return accessor.listExtensionArchives();
                }
                case PACKAGE: {
                    return ((RuntimeContext)this.callable).getPackageManifestManager().listLoadedPackages();
                }
                case SEMANTIC_TYPE: {
                    return ((RuntimeContext)this.callable).getSemanticTypeCache().listUserSemanticTypes();
                }
                case EVENT_PROTOTYPE: {
                    return this.listEventPrototypes();
                }
                case SERVICE: {
                    return this.getArtifactNames(accessor::listServiceTypes, accessor::listServicesByType);
                }
                case CLIENT_FACTORY: {
                    return this.getArtifactNames(accessor::listClientFactoryTypes, accessor::listClientFactoriesByType);
                }
                case JDBC_FACTORY: {
                    return this.getArtifactNames(accessor::listJDBCFactoryTypes, accessor::listJDBCFactoriesByType);
                }
                case TRANSPORT_FACTORY: {
                    return this.getArtifactNames(accessor::listTransportFactoryTypes, accessor::listTransportFactoriesByType);
                }
                case FILE_DESCRIPTOR: {
                    return FileDescriptorRepositoryUtils.listFileDescriptors().stream().map(d -> "FileDescriptor." + d).collect(Collectors.toList());
                }
                case JOB: {
                    return this.getScheduler(session).listJobs();
                }
                case TASKLIST: {
                    return this.getScheduler(session).listTaskLists();
                }
                case MLCACHE: {
                    return ImportOperation.listMlcache(new File(".mlcache"));
                }
                case OBJECT: {
                    return ImportOperation.listObjects(new File(FrmEntityType.OBJECT.getRelativePath()), namespace);
                }
                case FACETS: {
                    return this.getSchemaObjects(41).stream().map(o -> o.getObjectName().name).collect(Collectors.toList());
                }
                case ASPECTS: {
                    return this.getSchemaObjects(42).stream().map(o -> o.getObjectName().name).collect(Collectors.toList());
                }
            }
        } else {
            if (definition.type == FrmEntityType.SEMANTIC_TYPE && definition.withAncestors) {
                return this.listSemanticTypesWithAncestors(artifactNames, session);
            }
            if (definition.type == FrmEntityType.MLCACHE) {
                return ExportOperation.doListMlcache(artifactNames, ExportOperation.listMlcache(new File(".mlcache")));
            }
            if (definition.type == FrmEntityType.OBJECT) {
                return ExportOperation.doListObjects(artifactNames, ExportOperation.listObjects(new File(FrmEntityType.OBJECT.getRelativePath()), namespace));
            }
        }
        return artifactNames;
    }

    private List<String> listEventPrototypes() {
        return Stream.of(((RuntimeContext)this.callable).getEventDatagramFactory().listEventIds(), ((RuntimeContext)this.callable).getAdvisoryDatagramFactory().listEventIds(), ((RuntimeContext)this.callable).getExceptionDatagramFactory().listEventIds(), ((RuntimeContext)this.callable).getOpaqueDatagramFactory().listEventIds()).flatMap(Collection::stream).filter(AbstractDSLOperation::isUserEvent).collect(Collectors.toList());
    }

    private List<String> getArtifactNames(Callable<List<String>> typesGetter, AbstractExportImportOperation.Function<String, List<String>> namesGetter) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (String type : typesGetter.call()) {
            for (String name : namesGetter.apply(type)) {
                if (name.equalsIgnoreCase("prototype")) continue;
                result.add(type + "." + name);
            }
        }
        return result;
    }

    private List<String> listSemanticTypesWithAncestors(List<String> typeNames, MFSession session) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (String typeName : typeNames) {
            ArrayList<String> typeWithAncestors = new ArrayList<String>();
            this.findTypeWithAncestors(typeName, typeWithAncestors);
            if (typeWithAncestors.size() > 1) {
                this.raiseSLMessage("  Ancestors " + String.valueOf(typeWithAncestors.subList(1, typeWithAncestors.size())) + " found for semantic type '" + typeName + "'.\n", session);
            }
            result.addAll(typeWithAncestors);
        }
        return result;
    }

    private void findTypeWithAncestors(String typeName, List<String> result) {
        SemanticType type = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(typeName);
        if (type != null && !type.isSystem()) {
            result.add(typeName);
            if (type.getAncestorType() != null) {
                this.findTypeWithAncestors(type.getAncestorType(), result);
            }
        }
    }

    private AbstractExportImportOperation.Artifact getArchiveArtifact(FrmEntityType type, String name, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        return ExportOperation.doGetArtifact(type, name, ((RuntimeContext)this.callable).getRepositoryAccessor().getArchive(name), result);
    }

    private AbstractExportImportOperation.Artifact getExtArchiveArtifact(FrmEntityType type, String name, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        return ExportOperation.doGetArtifact(type, name, ((RuntimeContext)this.callable).getRepositoryAccessor().getExtensionArchive(name), result);
    }

    private AbstractExportImportOperation.Artifact getJobArtifact(FrmEntityType type, String name, MFSession session, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        Scheduler scheduler = this.getScheduler(session);
        ScheduledJob job = scheduler.getJob(name);
        if (job == null) {
            throw new Exception("Job not found.");
        }
        TaskList taskList = null;
        if (job.getTaskList() != null) {
            taskList = scheduler.getTaskList(job.getTaskList().getName());
        }
        if (taskList != null) {
            ExportOperation.doGetArtifact(this.makeTaskListArtifact(taskList), result);
            this.raiseSLMessage("  Task list '" + taskList.getName() + "' found for job '" + name + "'.\n", session);
        }
        return ExportOperation.doGetArtifact(type, name, ((RuntimeContext)this.callable).getXSerializer().serialize(job).getBytes(), result);
    }

    private AbstractExportImportOperation.Artifact getTaskListArtifact(FrmEntityType type, String name, MFSession session, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        TaskList taskList = this.getScheduler(session).getTaskList(name);
        if (taskList == null) {
            throw new Exception("Task list not found.");
        }
        return ExportOperation.doGetArtifact(this.makeTaskListArtifact(taskList), result);
    }

    private AbstractExportImportOperation.Artifact makeTaskListArtifact(TaskList taskList) throws Exception {
        return new AbstractExportImportOperation.TaskListArtifact(taskList.getName(), taskList.getOID().toString(), ((RuntimeContext)this.callable).getXSerializer().serialize(taskList).getBytes());
    }

    private AbstractExportImportOperation.Artifact getMlcacheArtifact(FrmEntityType type, String name, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        AbstractExportImportOperation.Artifact artifact = ExportOperation.doGetArtifact(type, name, null, result);
        artifact.setFile(Paths.get(new File(".mlcache").getPath(), name).toFile());
        return artifact;
    }

    private AbstractExportImportOperation.Artifact getFacetsArtifact(FrmEntityType type, String name, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        SchemaObject object = this.getSDSSchemaObject(name, 41);
        return ExportOperation.doGetArtifact(type, name, object.getSQL().getBytes(), result);
    }

    private AbstractExportImportOperation.Artifact getAspectsArtifact(FrmEntityType type, String name, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        SchemaObject object = this.getSDSSchemaObject(name, 42);
        return ExportOperation.doGetArtifact(type, name, object.getSQL().getBytes(), result);
    }

    private AbstractExportImportOperation.Artifact getObjectArtifact(FrmEntityType type, String name, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        String namespace = new File(name).getParentFile().getPath();
        String artifactName = new File(name).getName();
        if (artifactName.endsWith(".xdo")) {
            artifactName = artifactName.substring(0, artifactName.length() - 4);
        }
        if (artifactName.contains(".")) {
            artifactName = artifactName.substring(artifactName.indexOf(".") + 1);
        }
        Object object = RepositoryUtils.lookupObject(namespace, artifactName);
        return ExportOperation.doGetArtifact(type, name, ((RuntimeContext)this.callable).getXSerializer().serialize(object).getBytes(), result);
    }

    private AbstractExportImportOperation.Artifact getPackageArtifact(FrmEntityType type, String name, MFSession session, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        return new PackageArtifactGetter(type, name, session, false).execute(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AbstractExportImportOperation.Artifact getTypeArtifact(FrmEntityType type, String name, Set<String> foundSources, MFSession session, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        SemanticType semanticType = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(name);
        if (semanticType == null) {
            throw new Exception("Semantic type '" + name + "' not found.");
        }
        if (!semanticType.isValid()) {
            this.raiseSLMessageWarning("  ", "Semantic type '" + name + "' not valid. Skipped.", session);
            return null;
        }
        Package pkg = ((RuntimeContext)this.callable).getPackageLoaderRegistry().lookupPackageBySemanticType(semanticType);
        if (pkg != null) {
            if (foundSources.contains(pkg.getFullName())) return this.doGetTypeArtifact(semanticType, result);
            if (new PackageArtifactGetter(FrmEntityType.PACKAGE, pkg.getFullName(), session, true).execute(result) != null) {
                foundSources.add(pkg.getFullName());
                this.raiseSLMessage("  Package '" + pkg.getFullName() + "' found for semantic type '" + name + "'.\n", session);
                return this.doGetTypeArtifact(semanticType, result);
            }
        } else {
            List<String> jars = ((RuntimeContext)this.callable).getClassLoaderRegistry().listExtArchivesByClass(semanticType.getClassName());
            if (!jars.isEmpty()) {
                if (jars.size() > 1) {
                    this.raiseSLMessageWarning("  ", "Semantic type '" + name + "' found in more than one extension archive. Skipped.", session);
                    return null;
                }
                String jar = jars.get(0);
                if (foundSources.contains(jar)) return this.doGetTypeArtifact(semanticType, result);
                if (this.getExtArchiveArtifact(FrmEntityType.EXT_ARCHIVE, jar, result) != null) {
                    foundSources.add(jar);
                    this.raiseSLMessage("  Extension archive '" + jar + "' found for semantic type '" + name + "'.\n", session);
                    return this.doGetTypeArtifact(semanticType, result);
                }
            }
        }
        this.raiseSLMessageWarning("  ", "Package or extension archive not found for semantic type '" + name + "'. Skipped.", session);
        return null;
    }

    private AbstractExportImportOperation.Artifact getEventPrototypeArtifact(FrmEntityType type, String eventId, MFSession session, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        ImmutableEventDatagram datagram = null;
        if (((RuntimeContext)this.callable).getEventDatagramFactory().existsPrototype(eventId)) {
            datagram = ((RuntimeContext)this.callable).getEventDatagramFactory().createEvent(eventId);
        } else if (((RuntimeContext)this.callable).getAdvisoryDatagramFactory().existsPrototype(eventId)) {
            datagram = ((RuntimeContext)this.callable).getAdvisoryDatagramFactory().createEvent(eventId);
        } else if (((RuntimeContext)this.callable).getExceptionDatagramFactory().existsPrototype(eventId)) {
            datagram = ((RuntimeContext)this.callable).getExceptionDatagramFactory().createEvent(eventId);
        } else if (((RuntimeContext)this.callable).getOpaqueDatagramFactory().existsPrototype(eventId)) {
            datagram = ((RuntimeContext)this.callable).getOpaqueDatagramFactory().createEvent(eventId);
        } else {
            this.raiseSLMessageWarning("Cannot find factory for event [" + eventId + "]. Skipping.", session);
        }
        if (datagram != null) {
            DatagramFactory factory = ((RuntimeContext)this.callable).getDatagramFactoryManager().lookupDatagramFactoryByModel(datagram.getClass().getSimpleName());
            String filename = factory.getName() + "/" + datagram.getClass().getSimpleName() + "." + eventId.replace(".", "_") + ".xdo";
            AbstractExportImportOperation.EventPrototypeArtifact artifact = new AbstractExportImportOperation.EventPrototypeArtifact(type, eventId, datagram, filename);
            artifact.setData(((RuntimeContext)this.callable).getXSerializer().serialize(datagram).getBytes());
            result.add(artifact);
            return artifact;
        }
        return null;
    }

    private AbstractExportImportOperation.Artifact doGetTypeArtifact(SemanticType type, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        return ExportOperation.doGetArtifact(FrmEntityType.SEMANTIC_TYPE, type.getTypeName(), ((RuntimeContext)this.callable).getXSerializer().serialize(type).getBytes(), result);
    }

    private static AbstractExportImportOperation.Artifact doGetArtifact(FrmEntityType type, String name, byte[] data, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        return ExportOperation.doGetArtifact(new AbstractExportImportOperation.Artifact(type, name, data), result);
    }

    private static AbstractExportImportOperation.Artifact doGetArtifact(AbstractExportImportOperation.Artifact artifact, List<AbstractExportImportOperation.Artifact> result) throws Exception {
        result.add(artifact);
        return artifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportArtifacts(AbstractExportImportOperation.Definition definition, MFSession session, SLFileUtils frm, List<AbstractExportImportOperation.Artifact> artifacts) throws Exception {
        block19: {
            if (definition.location.toLowerCase().endsWith(".frm")) {
                File tmpFrm = File.createTempFile("FabricResourceModule", ".frm");
                try {
                    try (FrmFileWriter tmpFrmWriter = new FrmFileWriter(tmpFrm.getAbsolutePath(), Files.newOutputStream(tmpFrm.toPath(), new OpenOption[0]));){
                        this.copyExistingFrm(frm, definition.location, tmpFrmWriter, artifacts, session);
                        this.raiseSLMessage("Adding artifacts to FRM...\n", session);
                        for (AbstractExportImportOperation.Artifact artifact : artifacts) {
                            if (definition.targetPath != null) {
                                Object targetName = FrmEntityType.OBJECT.getRelativePath() + "/" + definition.targetPath + "/" + new File(artifact.getArchiveEntryName()).getName();
                                targetName = ((String)targetName).replace("//", "/");
                                this.raiseSLMessage("  Adding " + String.valueOf(artifact) + " to " + (String)targetName + "...\n", session);
                                tmpFrmWriter.addFile((String)targetName, artifact.getData());
                                continue;
                            }
                            this.raiseSLMessage("  Adding " + String.valueOf(artifact) + "...\n", session);
                            tmpFrmWriter.addFile(artifact.getArchiveEntryName(), artifact.getData());
                        }
                    }
                    this.raiseSLMessage("\nSaving FRM...\n", session);
                    try (FileInputStream tmpInput = new FileInputStream(tmpFrm);){
                        frm.createFile(definition.location, tmpInput, true);
                        break block19;
                    }
                }
                finally {
                    if (tmpFrm != null) {
                        tmpFrm.delete();
                    }
                }
            }
            this.raiseSLMessage("Adding artifacts to FRM...\n", session);
            for (AbstractExportImportOperation.Artifact artifact : artifacts) {
                this.raiseSLMessage("  Adding " + String.valueOf(artifact) + "\n", session);
                frm.createFile(definition.location + "/" + artifact.getFilename(), artifact.getData(), true);
            }
        }
    }

    private void copyExistingFrm(SLFileUtils from, String fromFilename, FrmFileWriter to, List<AbstractExportImportOperation.Artifact> newArtifacts, MFSession session) throws Exception {
        if (from.supportsExistsOperation() && from.exists()) {
            this.raiseSLMessage("Opening existing FRM...\n", session);
            Set newEntries = newArtifacts.stream().map(AbstractExportImportOperation.Artifact::getArchiveEntryName).map(entryName -> entryName.replace(File.separatorChar, '/')).collect(Collectors.toSet());
            try (InputStream inputFrmStream = ExportOperation.openInputStream(from, fromFilename);
                 FrmFileReader frmReader = new FrmFileReader(inputFrmStream);){
                String entryName2;
                while ((entryName2 = frmReader.getNextEntryPath()) != null && !newEntries.contains(entryName2)) {
                    to.addFile(entryName2, frmReader.getNextFile());
                }
            }
            this.raiseSLMessage("\n", session);
        }
    }

    protected SchemaObject getSDSSchemaObject(String name, int type) {
        return this.getStore().schemaManager.getSchemaObject(name, "SDS", type);
    }

    protected List<SchemaObject> getSchemaObjects(int type) {
        ArrayList<SchemaObject> res = new ArrayList<SchemaObject>();
        Iterator it = this.getStore().schemaManager.databaseObjectIterator(type);
        while (it.hasNext()) {
            res.add((SchemaObject)it.next());
        }
        return res;
    }

    private class PackageArtifactGetter
    extends ArtifactGetter {
        private boolean skipTypes;
        private PackageType pkgType;

        PackageArtifactGetter(FrmEntityType type, String name, MFSession session, boolean skipTypes) {
            super(type, name, session);
            this.skipTypes = false;
            this.skipTypes = skipTypes;
        }

        @Override
        void exportArtifact(String path, String name, String type) throws Exception {
            ((RuntimeContext)ExportOperation.this.callable).getRepositoryAccessor().exportPackage(path, this.pkgType, name);
        }

        @Override
        boolean doCheckExistence(String name, String type) throws Exception {
            this.pkgType = ExportOperation.getPackageType(type);
            return ((RuntimeContext)ExportOperation.this.callable).getRepositoryAccessor().existsPackage(this.pkgType, name);
        }

        @Override
        AbstractExportImportOperation.Artifact getArtifact(String tmpDirPath, List<AbstractExportImportOperation.Artifact> result) throws Exception {
            AbstractExportImportOperation.Artifact artifact = super.getArtifact(tmpDirPath, result);
            ArrayList<URL> jarUrls = new ArrayList<URL>();
            for (File jar : FileIOUtils.directoryList(tmpDirPath, ".jar")) {
                ExportOperation.doGetArtifact(FrmEntityType.ARCHIVE, jar.getName(), FileIOUtils.getFileContent(jar), result);
                if (this.skipTypes) continue;
                jarUrls.add(((RuntimeContext)ExportOperation.this.callable).getRepositoryAccessor().getArchiveURL(jar.getName()));
            }
            if (!this.skipTypes) {
                for (SemanticType type : ExportOperation.this.getRelatedSemanticTypes(jarUrls)) {
                    ExportOperation.this.doGetTypeArtifact(type, result);
                }
            }
            return artifact;
        }
    }

    private abstract class ArtifactGetter {
        FrmEntityType type;
        String name;
        MFSession session;

        ArtifactGetter(FrmEntityType type, String name) {
            this.type = type;
            this.name = name;
        }

        ArtifactGetter(FrmEntityType type, String name, MFSession session) {
            this(type, name);
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbstractExportImportOperation.Artifact execute(List<AbstractExportImportOperation.Artifact> result) throws Exception {
            Prototype prototype = Prototype.parseName(this.name, false);
            if (this.checkExistence(prototype.getInstanceName(), prototype.getModelName())) {
                File tmpDir = ExportOperation.this.createTempDir();
                try {
                    this.exportArtifact(tmpDir.getAbsolutePath(), prototype.getInstanceName(), prototype.getModelName());
                    AbstractExportImportOperation.Artifact artifact = this.getArtifact(tmpDir.getAbsolutePath(), result);
                    return artifact;
                }
                finally {
                    FileIOUtils.deleteFileDir(tmpDir);
                }
            }
            return null;
        }

        boolean checkExistence(String name, String type) throws Exception {
            if (!this.doCheckExistence(name, type)) {
                throw new Exception("Artifact '" + Prototype.toString(type, name) + "' not found.");
            }
            return true;
        }

        abstract boolean doCheckExistence(String var1, String var2) throws Exception;

        abstract void exportArtifact(String var1, String var2, String var3) throws Exception;

        AbstractExportImportOperation.Artifact getArtifact(String tmpDirPath, List<AbstractExportImportOperation.Artifact> result) throws Exception {
            return ExportOperation.doGetArtifact(this.type, this.name, FileIOUtils.getFileContent(new File(tmpDirPath, ExportOperation.getFilename(this.type, this.name))), result);
        }
    }
}

