/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.repository;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.repository.AbstractRepositoryOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.FeedbackOperationInvoker;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;

public class DropExtArchiveOperation
extends AbstractRepositoryOperation {
    public static final String NAME = "drop ext archive";

    public DropExtArchiveOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP EXT ARCHIVE").addActionParameter(new IdentifierParameter("JarName"));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("WITH TYPES"))).addModifier(new Modifier("ALL")));
        this.syntax.addModifier(new Modifier("FORCE", false));
        this.syntax.setDescription("Drops the specified extension archive.\nThis archive will be dropped in all nodes of Sysplex.\nBy default this operation does not remove dependent stuff (semantic types and event prototypes).");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   force              - Drops the archive even if there are dependent semantic types.\n   with types         - Drops the archive with its dependent semantic types.\n      force           - Drops the archive with its dependent types even if there are entities\n                        that depend on these types (e.g. event prototypes).\n   all                - Drops the archive with all dependent stuff (semantic types and event prototypes).\n      force           - Drops the archive with all dependent stuff even if there are sub-entities\n                        that depend on this stuff (e.g. event flows).");
        this.syntax.setExamples("drop ext archive test.jar\ndrop ext archive test.jar force\ndrop ext archive test.jar force with types\ndrop ext archive test.jar force with types force\ndrop ext archive test.jar force all\ndrop ext archive test.jar force all force");
        this.syntax.addCompletionCommand("list ext archives");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            completions.addAll(((RuntimeContext)this.callable).getRepositoryAccessor().listExtensionArchives());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return new FeedbackOperationInvoker(){

            @Override
            protected SLResponse onInvoke(SLStatement statement, MFSession session) throws Exception {
                Definition definition = (Definition)statement;
                if (!((RuntimeContext)DropExtArchiveOperation.this.callable).getRepositoryAccessor().existsExtensionArchive(definition.jarName)) {
                    throw new Exception("Archive not found.");
                }
                if (definition.withTypes) {
                    SemanticUtils.dropArchiveDependentEntities(definition.jarName, true, definition.force, definition.all, (RuntimeContext)DropExtArchiveOperation.this.callable, this);
                }
                ((RuntimeContext)DropExtArchiveOperation.this.callable).getRepositoryAccessor().removeExtensionArchive(definition.jarName, definition.force);
                this.addFeedback("Archive dropped.");
                return new SLResponse();
            }
        }.invoke(statement, session);
    }

    static class Definition
    extends AbstractRepositoryOperation.DropDefinition {
        Definition(DSLStatement statement) {
            super(DropExtArchiveOperation.NAME, statement);
        }
    }
}

