/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.repository;

import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.repository.AbstractRepositoryOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.FeedbackOperationInvoker;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;

public class DropArchiveOperation
extends AbstractRepositoryOperation {
    public static final String NAME = "drop archive";

    public DropArchiveOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP ARCHIVE").addActionParameter(new IdentifierParameter("JarName"));
        this.syntax.addModifier(new CompoundModifier(false).addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier().addModifier(new Modifier("WITH TYPES"))).addModifier(new Modifier("ALL"))).addModifier(new Modifier("FORCE", false)));
        this.syntax.setDescription("Drops the specified archive.\nBy default this operation does not remove dependent stuff (semantic types and event prototypes).");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   with types - Drops the archive with its dependent semantic types.\n      force   - Drops the archive with its dependent types even if there are entities\n                that depend on these types (e.g. event prototypes).\n   all        - Drops the archive with all dependent stuff (semantic types and event prototypes).\n      force   - Drops the archive with all dependent stuff even if there are sub-entities\n                that depend on this stuff (e.g. event flows).\n   at node    - Drops the archive in the specified node.\n   at domain  - Drops the archive in all nodes of the sysplex.");
        this.syntax.setExamples("drop archive test.jar\ndrop archive test.jar with types\ndrop archive test.jar with types force\ndrop archive test.jar all\ndrop archive test.jar all force\ndrop archive test.jar at domain");
        this.syntax.addCompletionCommand("list archives");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            completions.addAll(((RuntimeContext)this.callable).getRepositoryAccessor().listArchives());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        return new FeedbackOperationInvoker(){

            @Override
            protected SLResponse onInvoke(SLStatement statement, MFSession session) throws Exception {
                Definition definition = (Definition)statement;
                if (!((RuntimeContext)DropArchiveOperation.this.callable).getRepositoryAccessor().existsArchive(definition.jarName)) {
                    throw new Exception("Archive not found.");
                }
                Package pkg = ((RuntimeContext)DropArchiveOperation.this.callable).getRepositoryAccessor().getPackageByArchive(definition.jarName);
                if (pkg != null) {
                    throw new Exception("Archive belongs to package '" + pkg.getFullName() + "' and cannot be dropped.");
                }
                if (definition.withTypes) {
                    SemanticUtils.dropArchiveDependentEntities(definition.jarName, false, definition.force, definition.all, (RuntimeContext)DropArchiveOperation.this.callable, this);
                }
                ((RuntimeContext)DropArchiveOperation.this.callable).getRepositoryAccessor().removeArchive(definition.jarName);
                this.addFeedback("Archive dropped.");
                return new SLResponse();
            }
        }.invoke(statement, session);
    }

    static class Definition
    extends AbstractRepositoryOperation.DropDefinition {
        Definition(DSLStatement statement) {
            super(DropArchiveOperation.NAME, statement);
        }
    }
}

