/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.repository;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.repository.AbstractRepositoryOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;

public class DescribeExtArchiveOperation
extends AbstractRepositoryOperation {
    public static final String NAME = "describe ext archive";

    public DescribeExtArchiveOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE EXT ARCHIVE").addActionParameter(new IdentifierParameter("ArchiveName"));
        this.addTypesModifier(false);
        this.syntax.setDescription("Shows information about the specified extension archive.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   types - Shows a list of semantic types whose classes are located in this archive.");
        this.syntax.addCompletionCommand("list ext archives");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            completions.addAll(((RuntimeContext)this.callable).getRepositoryAccessor().listExtensionArchives());
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ArchiveName").getValue(), statement.existsModifier("TYPES"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsExtensionArchive(definition.jarName)) {
            return new SLResponse("Archive not found.", false);
        }
        return this.doDescribeArchive(definition, true, () -> ((RuntimeContext)this.callable).getRepositoryAccessor().getExtensionArchiveURL(definition.jarName), null);
    }

    static class Definition
    extends AbstractRepositoryOperation.DescribeDefinition {
        Definition(String jarName, boolean types) {
            super(DescribeExtArchiveOperation.NAME, jarName, types);
        }
    }
}

