/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.repository;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.repository.AbstractAnalyzeDependenciesOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.List;

public class AnalyzeExtArchiveDependenciesOperation
extends AbstractAnalyzeDependenciesOperation {
    public static final String NAME = "analyze ext archive";

    public AnalyzeExtArchiveDependenciesOperation() {
        this.syntax.setDescription("Shows dependencies of the specified extension archive.");
        this.syntax.addCompletionCommand("list ext archives");
    }

    @Override
    protected String getEntity() {
        return "ext archive";
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            completions.addAll(((RuntimeContext)this.callable).getRepositoryAccessor().listExtensionArchives());
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractAnalyzeDependenciesOperation.Definition definition = (AbstractAnalyzeDependenciesOperation.Definition)statement;
        if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsExtensionArchive(definition.entityName)) {
            throw new Exception("Archive not found.");
        }
        return this.doInvokeForArchives(definition, true);
    }
}

