/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.repository;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.repository.AbstractAlterOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.io.File;
import java.util.List;

public class AlterExtArchiveOperation
extends AbstractAlterOperation {
    public static final String NAME = "alter ext archive";

    public AlterExtArchiveOperation() {
        super(NAME);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addCompletionCommand("list ext archives");
    }

    @Override
    public AbstractAlterOperation.Definition createDefinition(String jarName, String location) {
        return new AbstractAlterOperation.Definition(NAME, jarName, location);
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            completions.addAll(((RuntimeContext)this.callable).getRepositoryAccessor().listExtensionArchives());
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractAlterOperation.Definition definition = (AbstractAlterOperation.Definition)statement;
        File jar = this.getJar(session, definition);
        ((RuntimeContext)this.callable).getRepositoryAccessor().removeExtensionArchive(definition.getJarName(), true);
        this.addJarToRepository(jar, file -> ((RuntimeContext)this.callable).getRepositoryAccessor().addExtensionArchive(jar));
        return new SLResponse();
    }
}

