/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.repository;

import com.streamscape.Trace;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeManifestManager;
import com.streamscape.runtime.mf.operation.repository.AbstractAlterOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.io.File;
import java.util.List;

public class AlterArchiveOperation
extends AbstractAlterOperation {
    public static final String NAME = "alter archive";

    public AlterArchiveOperation() {
        super(NAME);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addCompletionCommand("list archives");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            completions.addAll(((RuntimeContext)this.callable).getRepositoryAccessor().listArchives());
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    @Override
    public AbstractAlterOperation.Definition createDefinition(String jarName, String location) {
        return new AbstractAlterOperation.Definition(NAME, jarName, location);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractAlterOperation.Definition definition = (AbstractAlterOperation.Definition)statement;
        File jar = this.getJar(session, definition);
        Package pkg = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackageByArchive(definition.getJarName());
        if (pkg != null) {
            boolean loaded = false;
            RuntimeManifestManager manifestManager = ((RuntimeContext)this.callable).getPackageManifestManager();
            if (manifestManager.isPackageLoaded(pkg.getFullName())) {
                manifestManager.unloadPackage(pkg.getFullName());
            }
            this.updateArchive(jar);
            if (loaded) {
                manifestManager.loadPackage(pkg.getFullName());
            }
        } else {
            this.updateArchive(jar);
        }
        return new SLResponse();
    }

    private void updateArchive(File jar) throws Exception {
        ((RuntimeContext)this.callable).getRepositoryAccessor().removeArchive(jar.getName());
        this.addJarToRepository(jar, file -> ((RuntimeContext)this.callable).getRepositoryAccessor().addArchive(jar));
    }
}

