/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.repository;

import com.streamscape.lib.loader.TFCacheJarStorage;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class AbstractRepositoryOperation
extends AbstractOperation<RuntimeContext> {
    protected AbstractRepositoryOperation() {
        super(false, false);
    }

    protected AbstractRepositoryOperation(boolean isAdministrative) {
        super(isAdministrative, false);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.repository);
    }

    protected void addTypesModifier(boolean required) {
        this.syntax.addModifier(((CompoundModifier)new CompoundModifier(required).setSyntaxHintSpace()).addModifier(new Modifier("SEMANTIC", false)).addModifier(new Modifier("TYPES")));
    }

    protected static RowMetaData createResultDescriptorForDescribe(boolean types) {
        RowMetaData result = new RowMetaData();
        if (types) {
            AbstractRepositoryOperation.addColumn(result, "Type");
            AbstractRepositoryOperation.addColumn(result, "Valid");
        } else {
            AbstractRepositoryOperation.addColumn(result, "Property");
            AbstractRepositoryOperation.addColumn(result, "Value");
        }
        return result;
    }

    protected SLResponse doDescribeArchive(DescribeDefinition definition, boolean isExt, Callable<URL> jarGetter, Consumer<RowSet> otherParametersHandler) throws Exception {
        RowSet result = new RowSet(AbstractRepositoryOperation.createResultDescriptorForDescribe(definition.types));
        if (definition.types) {
            this.addTypes(SemanticUtils.getRelatedSemanticTypes(definition.jarName, isExt, (RuntimeContext)this.callable), result);
        } else {
            URL jarUrl = jarGetter.call();
            AbstractRepositoryOperation.addValues(result, "Name", definition.jarName);
            File file = TFCacheJarStorage.getInstance().getJarFileInfo(jarUrl).getFile();
            AbstractRepositoryOperation.addValues(result, "Size", AbstractOperation.Scale.BYTES.format(file.length()));
            AbstractRepositoryOperation.addValues(result, "Created On", AbstractRepositoryOperation.formatCreationDate(file));
            AbstractRepositoryOperation.addValues(result, "Last Modified On", AbstractRepositoryOperation.formatDate(file.lastModified()));
            if (otherParametersHandler != null) {
                otherParametersHandler.accept(result);
            }
            AbstractRepositoryOperation.addValues(result, "Semantic Types", SemanticUtils.getRelatedSemanticTypes(Arrays.asList(jarUrl), (FabricContext)((Object)this.callable)).stream().map(SemanticType::getTypeName).collect(Collectors.toList()));
        }
        return new SLResponse(result);
    }

    protected void addTypes(List<SemanticType> types, RowSet result) {
        types.forEach(type -> AbstractRepositoryOperation.add(result, new Object[]{type.getTypeName(), type.isValid()}));
    }

    static class DescribeDefinition
    extends AbstractSLStatement {
        String jarName;
        boolean types;

        DescribeDefinition(String operationName, String jarName, boolean types) {
            super(operationName);
            this.jarName = jarName;
            this.types = types;
        }
    }

    protected static class DropDefinition
    extends AbstractSLStatement {
        protected String jarName;
        protected boolean all;
        protected boolean withTypes;
        protected boolean force;
        protected String nodeName;

        protected DropDefinition(String operationName, DSLStatement statement) {
            super(operationName);
            this.jarName = statement.getParameter("JarName").getValue();
            this.all = statement.existsModifier("ALL");
            this.force = statement.existsModifier("FORCE");
            this.nodeName = AtNodeOrAtDomainModifier.getValue(statement);
            this.withTypes = this.all || statement.existsModifier("WITH TYPES");
        }
    }
}

