/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.repository;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.repository.AbstractRepositoryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public abstract class AbstractAnalyzeDependenciesOperation
extends AbstractRepositoryOperation {
    protected AbstractAnalyzeDependenciesOperation() {
        this.createDSLSyntax("analyze " + this.getEntity());
        AbstractAnalyzeDependenciesOperation.fillSyntax(this.syntax, this.getEntity(), new IdentifierParameter(StringUtils.toCapitalized(this.getEntity()) + "Name"));
    }

    public static void fillSyntax(DSLStatementSyntax syntax, String entity, AbstractParameter nameParameter) {
        syntax.setAction("ANALYZE " + entity.toUpperCase()).addActionParameter(nameParameter);
    }

    protected abstract String getEntity();

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.getName(), statement.getParameter(StringUtils.toCapitalized(this.getEntity()) + "Name").getValue());
    }

    protected SLResponse doInvokeForArchives(Definition definition, boolean isExtArchive) throws Exception {
        RowSet result = new RowSet(AbstractAnalyzeDependenciesOperation.createSimpleResultDescriptor());
        SemanticUtils.ArchiveDependencies dependencies = SemanticUtils.getArchiveDependencies(definition.entityName, isExtArchive, (RuntimeContext)this.callable);
        AbstractAnalyzeDependenciesOperation.add(result, new Object[]{"Depends On Ext Archives", dependencies.backwardExt});
        AbstractAnalyzeDependenciesOperation.add(result, new Object[]{"Depends On Lib Archives", dependencies.backwardLib});
        AbstractAnalyzeDependenciesOperation.add(result, new Object[]{"Dependent Ext Archives", dependencies.forwardExt});
        AbstractAnalyzeDependenciesOperation.add(result, new Object[]{"Dependent Lib Archives", dependencies.forwardLib});
        return new SLResponse(result);
    }

    protected static class Definition
    extends AbstractSLStatement {
        String entityName;

        Definition(String operationName, String entityName) {
            super(operationName);
            this.entityName = entityName;
        }

        public String getEntityName() {
            return this.entityName;
        }
    }
}

