/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.repository;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.repository.AbstractRepositoryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;

abstract class AbstractAlterOperation
extends AbstractRepositoryOperation {
    private static final String FILE_EXTENSION = ".jar";

    protected AbstractAlterOperation(String name) {
        super(true);
        this.createDSLSyntax(name);
        this.syntax.setAction(name.toUpperCase());
        this.syntax.addActionParameter((SyntaxParameter)new IdentifierParameter("JarName").addExclusionValue("FROM"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FROM").addParameter(new SLFilePathParameter("Location"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setExamples(name + " Example.jar from 'C:\\StreamScape\\Temp'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.createDefinition(statement.getParameter("JarName").getValue(), statement.getParameter("Location").getValue());
    }

    public abstract Definition createDefinition(String var1, String var2);

    protected File getJar(MFSession session, Definition definition) throws Exception {
        File file;
        block9: {
            Object filename = definition.getJarName();
            if (!((String)filename).toLowerCase().endsWith(FILE_EXTENSION)) {
                filename = (String)filename + FILE_EXTENSION;
                definition.setJarName((String)filename);
            }
            File jar = new File(FileIOUtils.createTempDir(new File(((RuntimeContext)this.callable).getStartupDir())), (String)filename);
            OutputStream stream = Files.newOutputStream(jar.toPath(), new OpenOption[0]);
            try {
                ((SLFileUtils)new SLFileUtilsFactory().create(session, definition.location + "/" + (String)filename)).readFile(stream);
                file = jar;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new Exception("Obtaining archive '" + (String)filename + "' failed.", exception);
                }
            }
            stream.close();
        }
        return file;
    }

    protected void addJarToRepository(File jar, Utils.Consumer<File> addArchiveMethod) throws Exception {
        try {
            addArchiveMethod.accept(jar);
        }
        finally {
            FileIOUtils.deleteFileDir(jar.getParentFile());
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private String jarName;
        private String location;

        public Definition(String operationName, String jarName, String location) {
            super(operationName);
            this.jarName = jarName;
            this.location = location;
        }

        public String getJarName() {
            return this.jarName;
        }

        public void setJarName(String jarName) {
            this.jarName = jarName;
        }

        public String getLocation() {
            return this.location;
        }
    }
}

