/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.List;

public class ValidatePackageOperation
extends AbstractPackageOperation {
    public static final String NAME = "validate package";

    public ValidatePackageOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("VALIDATE PACKAGE").addActionParameter(new AbstractPackageOperation.PackageTypeNameParameter());
        this.syntax.setDescription("Validates all entities that depend on the specified package (semantic types, event prototypes etc).\nOnly SDO or Collection packages can be validated. Package must be loaded to be validated.");
        this.syntax.setExamples("validate package sdo.TestPackage\n");
        this.syntax.addCompletionCommand("list packages");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.fillLoadedPackages(completions);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractPackageOperation.Definition(NAME, ValidatePackageOperation.getPackageType(statement), ValidatePackageOperation.getPackageName(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractPackageOperation.Definition definition = (AbstractPackageOperation.Definition)statement;
        ((RuntimeContext)this.callable).getPackageManifestManager().validatePackage(Package.getFullName(ValidatePackageOperation.getType(definition.packageType), definition.packageName));
        return new SLResponse();
    }
}

