/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.List;

public class UnregisterPackageOperation
extends AbstractPackageOperation {
    public static final String NAME = "unregister package";

    public UnregisterPackageOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("UNREGISTER PACKAGE").addActionParameter(new AbstractPackageOperation.PackageTypeNameParameter());
        this.syntax.setDescription("Unregisters the specified package from the Runtime Package Manifest.\n" + UnregisterPackageOperation.getSupportedTypes());
        this.syntax.setExamples("unregister package service.TestPackage");
        this.syntax.addCompletionCommand("list packages");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(UnregisterPackageOperation.getPackageType(statement), UnregisterPackageOperation.getPackageName(statement));
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.fillRegisteredPackages(completions);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ((RuntimeContext)this.callable).getPackageManifestManager().removePackage(definition.getPackageType() + "." + definition.getPackageName());
        return new SLResponse();
    }

    public static class Definition
    extends AbstractPackageOperation.Definition {
        public Definition(String packageType, String packageName) {
            super(UnregisterPackageOperation.NAME, packageType, packageName);
        }
    }
}

