/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AbstractDiagnosticOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;

public class ShowLoaderChainOperation
extends AbstractDiagnosticOperation<RuntimeContext> {
    public static final String NAME = "show loader chain";

    public ShowLoaderChainOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW LOADER CHAIN");
        this.syntax.addModifier(new CompoundModifier(false).addModifier(new Modifier("OBJECT")).addModifier(new CompoundModifier(false).addModifier(new Modifier("AS")).addModifier(new ChoiceModifier().addPossibleValues("JSON", "XML"))));
        this.syntax.setDescription("Shows information about the JVM's class loader chains and all their dependencies.\nMay be useful for understanding class dependencies and dealing with issues such as \nclass/package sealing exception, that could result from duplicate or inaccessible classes \nregistered in the virtual machine.");
        this.syntax.addTag(OperationTag.pkg);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition result = new Definition();
        if (statement.existsModifier("OBJECT")) {
            result.payload = statement.existsModifier("JSON") ? Payload.JSON : (statement.existsModifier("XML") ? Payload.XML : Payload.OBJECT);
        }
        return result;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.payload != null) {
            List<Pair<String, List<String>>> result = ((RuntimeContext)this.callable).getPackageLoaderRegistry().getAllClassPaths();
            if (definition.payload == Payload.JSON) {
                return new SLResponse(((RuntimeContext)this.callable).getJSONSerializer().serialize(result));
            }
            if (definition.payload == Payload.XML) {
                return new SLResponse(((RuntimeContext)this.callable).getXSerializer().serialize(result));
            }
            SLResponse response = new SLResponse();
            response.setObject(result);
            return response;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ((RuntimeContext)this.callable).getPackageLoaderRegistry().printAllClassPaths(new PrintStream(stream, true));
        stream.close();
        return new SLResponse(stream.toString());
    }

    public static class Definition
    extends AbstractSLStatement {
        Payload payload;

        public Definition() {
            super(ShowLoaderChainOperation.NAME);
        }
    }

    static enum Payload {
        OBJECT,
        JSON,
        XML;

    }
}

