/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.List;

public class RegisterPackageOperation
extends AbstractPackageOperation {
    public static final String NAME = "register package";

    public RegisterPackageOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REGISTER PACKAGE").addActionParameter(new AbstractPackageOperation.PackageTypeNameParameter());
        this.syntax.addModifier(new AbstractPackageOperation.PackageAutoloadModifier());
        this.syntax.addModifier(new AbstractPackageOperation.PackageSequenceModifier());
        this.syntax.addModifier(new AbstractPackageOperation.PackageGlobalModifier());
        this.syntax.setDescription("Registers the specified package in Runtime Package Manifest.\n" + RegisterPackageOperation.getSupportedTypes());
        this.syntax.setExamples("register package service.TestPackage\nregister package service.TestPackage autoload true\nregister package service.TestPackage autoload true sequence 1\nregister package collection.TestPackage global true");
        this.syntax.addCompletionCommand("list packages");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.fillUnregisteredPackages(completions);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.parseManifestSyntax(statement, null);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.doRegisterPackage((Definition)statement, ((RuntimeContext)this.callable).getPackageManifestManager());
        return new SLResponse();
    }

    @Override
    protected AbstractPackageOperation.ManifestDefinition createManifestDefinition(String packageType, String packageName) {
        return new Definition(packageType, packageName);
    }

    public static class Definition
    extends AbstractPackageOperation.ManifestDefinition {
        public Definition(String packageType, String packageName) {
            super(RegisterPackageOperation.NAME, packageType, packageName);
        }

        public Definition(String packageType, String packageName, boolean autoload, boolean global, int sequence) {
            super(RegisterPackageOperation.NAME, packageType, packageName, autoload, global, sequence);
        }
    }
}

