/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.List;

public class LoadPackageOperation
extends AbstractPackageOperation {
    public static final String NAME = "load package";

    public LoadPackageOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LOAD PACKAGE").addActionParameter(new AbstractPackageOperation.PackageTypeNameParameter());
        this.addNovalidateModifier();
        this.syntax.setDescription("Loads the previously registered package to the package loader registry of the Runtime Package Manifest.\nThis operation loads all JARs associated with the package to a new class loader.\n" + LoadPackageOperation.getSupportedTypes());
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   no validate - Indicates that package-dependent entities (semantic types and event prototypes)\n                 will not be validated after loading. This may allow to load the package faster and\n                 can be important in the case of a large package with many dependent entities.");
        this.syntax.setExamples("load package sdo.TestPackage\nload package sdo.TestPackage no validate");
        this.syntax.addCompletionCommand("list packages");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.fillUnLoadedPackages(completions);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(LoadPackageOperation.getPackageType(statement), LoadPackageOperation.getPackageName(statement), statement.existsModifier("NO VALIDATE"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        String pkgFullName = Package.getFullName(LoadPackageOperation.getType(definition.packageType), definition.packageName);
        ((RuntimeContext)this.callable).getPackageManifestManager().loadPackage(pkgFullName, !definition.noValidate);
        this.checkDependentPackages(pkgFullName, session);
        return new SLResponse();
    }

    static class Definition
    extends AbstractPackageOperation.LoadUnloadDefinition {
        public Definition(String packageType, String packageName, boolean noValidate) {
            super(LoadPackageOperation.NAME, packageType, packageName, noValidate);
        }
    }
}

