/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.Collections;
import java.util.List;

public class ListPackagesOperation
extends AbstractPackageOperation {
    public static final String NAME = "list packages";

    public ListPackagesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST PACKAGES");
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("TYPE").addParameter(new IdentifierParameter("PackageType"))).setRequired(false)).setSyntaxHintSpace());
        this.syntax.setDescription("Returns a list of all packages in Repository of the node.\n" + AbstractPackageOperation.getSupportedTypes());
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("PackageType").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ListPackagesOperation.createResultDescriptor(definition.getPackageType() == null));
        if (definition.getPackageType() != null) {
            PackageType type = AbstractPackageOperation.getType(definition.packageType);
            List<String> pkgs = ((RuntimeContext)this.callable).getRepositoryAccessor().listPackagesByType(type);
            Collections.sort(pkgs);
            for (String pkgName : pkgs) {
                Package pkg = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackage(type, pkgName);
                ListPackagesOperation.addValues(result, pkg.getName(), pkg.getVersion(), ListPackagesOperation.formatTimestamp(pkg), pkg.isGlobal(), pkg.isAutoload(), pkg.isValid());
            }
        } else {
            List<String> pkgs = ((RuntimeContext)this.callable).getRepositoryAccessor().listPackages();
            Collections.sort(pkgs);
            for (String pkgName : pkgs) {
                Package pkg = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackage(pkgName);
                ListPackagesOperation.addValues(result, pkg.getType().name(), pkg.getName(), pkg.getVersion(), ListPackagesOperation.formatTimestamp(pkg), pkg.isGlobal(), pkg.isAutoload(), pkg.isValid());
            }
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor(boolean withType) {
        RowMetaData result = new RowMetaData(10);
        if (withType) {
            ListPackagesOperation.addColumn(result, "Package Type");
        }
        ListPackagesOperation.addColumn(result, "Package Name");
        ListPackagesOperation.addColumn(result, "Version");
        ListPackagesOperation.addColumn(result, "Timestamp");
        ListPackagesOperation.addColumn(result, "Global");
        ListPackagesOperation.addColumn(result, "Autoload");
        ListPackagesOperation.addColumn(result, "Valid");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String packageType;

        public Definition(String packageType) {
            super(ListPackagesOperation.NAME);
            this.packageType = packageType;
        }

        public String getPackageType() {
            return this.packageType;
        }
    }
}

