/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.FeedbackOperationInvoker;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.List;

public class DropPackageOperation
extends AbstractPackageOperation {
    public static final String NAME = "drop package";

    public DropPackageOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP PACKAGE").addActionParameter(new AbstractPackageOperation.PackageTypeNameParameter());
        this.syntax.addModifier(new CompoundModifier(false).addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier().addModifier(new CompoundModifier().addModifier(new Modifier("ARCHIVES")).addModifier(new Modifier("WITH TYPES", false)))).addModifier(new Modifier("ALL"))).addModifier(new Modifier("FORCE", false)));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Drops the specified package.\n" + DropPackageOperation.getSupportedTypes() + "\nBy default this operation does not remove dependent stuff (archives, semantic types, event prototypes).");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   archives      - Drops the package and its archives, but not dependent semantic types.\n      with types - Drops the package, its archives and dependent semantic types.\n         force   - Drops the package, its archives and dependent semantic types even if there are entities\n                   that depend on these types (e.g. event prototypes).\n   all           - Drops the package with all dependent stuff (its archives, semantic types and event prototypes).\n      force      - Drops the package with all dependent stuff even if there are sub-entities\n                   that depend on this stuff (e.g. event flows).\n   at node       - Drops the package in the specified node.\n   at domain     - Drops the package in all nodes of the sysplex.");
        this.syntax.setExamples("drop package sdo.TestPackage\ndrop package sdo.TestPackage archives\ndrop package sdo.TestPackage archives with types\ndrop package sdo.TestPackage archives with types force\ndrop package sdo.TestPackage all\ndrop package sdo.TestPackage all force\ndrop package sdo.TestPackage all force at domain");
        this.syntax.addCompletionCommand("list packages");
        this.syntax.addTag(OperationTag.repository);
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.fillAllPackages(completions);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if (statement.existsModifier("WITH TYPES") && !statement.existsModifier("ARCHIVES")) {
            throw new ParsingException(this.getSyntaxErrorMessage("Parameter 'with types' must be specified with parameter 'archives'."), this);
        }
        if (statement.existsModifier("ARCHIVES") && statement.existsModifier("FORCE") && !statement.existsModifier("WITH TYPES")) {
            throw new ParsingException(this.getSyntaxErrorMessage("Parameter 'force' must be specified with parameter 'with types'."), this);
        }
        return new Definition(DropPackageOperation.getPackageType(statement), DropPackageOperation.getPackageName(statement), statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        return new FeedbackOperationInvoker(){

            @Override
            protected SLResponse onInvoke(SLStatement statement, MFSession session) throws Exception {
                Definition definition = (Definition)statement;
                PackageType packageType = AbstractPackageOperation.getType(definition.packageType);
                if (!((RuntimeContext)DropPackageOperation.this.callable).getRepositoryAccessor().existsPackage(packageType, definition.packageName)) {
                    throw new Exception("Package not found.");
                }
                String packageFullName = Package.getFullName(packageType, definition.packageName);
                if (((RuntimeContext)DropPackageOperation.this.callable).getPackageManifestManager().isPackageLoaded(packageFullName)) {
                    throw new Exception("Package is loaded and cannot be dropped.");
                }
                if (((RuntimeContext)DropPackageOperation.this.callable).getPackageManifestManager().existsPackage(packageFullName)) {
                    throw new Exception("Package is registered and cannot be dropped.");
                }
                SemanticUtils.dropPackage(packageType, definition.packageName, definition.archives, definition.withTypes, definition.all, definition.force, (RuntimeContext)DropPackageOperation.this.callable, this);
                this.addFeedback("Package dropped.");
                return new SLResponse();
            }
        }.invoke(statement, session);
    }

    static class Definition
    extends AbstractPackageOperation.Definition {
        boolean all;
        boolean archives;
        boolean withTypes;
        boolean force;
        String nodeName;

        protected Definition(String packageType, String packageName, DSLStatement statement) {
            super(DropPackageOperation.NAME, packageType, packageName);
            this.all = statement.existsModifier("ALL");
            this.force = statement.existsModifier("FORCE");
            this.nodeName = AtNodeOrAtDomainModifier.getValue(statement);
            this.archives = this.all || statement.existsModifier("ARCHIVES");
            this.withTypes = this.all || statement.existsModifier("WITH TYPES");
        }
    }
}

