/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.List;

public class DescribePackageOperation
extends AbstractPackageOperation {
    public static final String NAME = "describe package";

    public DescribePackageOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE PACKAGE").addActionParameter(new AbstractPackageOperation.PackageTypeNameParameter());
        this.addTypesModifier(false);
        this.syntax.setDescription("Shows information about the specified package.\n" + DescribePackageOperation.getSupportedTypes());
        this.syntax.setExamples("describe package service.TestPackage");
        this.syntax.addCompletionCommand("list packages");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(DescribePackageOperation.getPackageType(statement), DescribePackageOperation.getPackageName(statement), statement.existsModifier("TYPES"));
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.fillAllPackages(completions);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Package pkg = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackage(AbstractPackageOperation.getType(definition.packageType), definition.packageName);
        RowSet result = new RowSet(DescribePackageOperation.createResultDescriptorForDescribe(definition.types));
        if (definition.types) {
            this.addTypes(SemanticUtils.getRelatedSemanticTypes(pkg, (RuntimeContext)this.callable), result);
        } else {
            DescribePackageOperation.addValues(result, "Package Name", pkg.getName());
            DescribePackageOperation.addValues(result, "Package Type", pkg.getType().name());
            DescribePackageOperation.addValues(result, "Description", DescribePackageOperation.skipNull(pkg.getDescription()));
            DescribePackageOperation.addValues(result, "Version", pkg.getVersion());
            DescribePackageOperation.addValues(result, "Timestamp", DescribePackageOperation.formatTimestamp(pkg));
            DescribePackageOperation.addValues(result, "Archives", pkg.listJARs());
            DescribePackageOperation.addValues(result, "Global", pkg.isGlobal());
            DescribePackageOperation.addValues(result, "Autoload", pkg.isAutoload());
            DescribePackageOperation.addValues(result, "Dependencies", pkg.listDependencies());
            DescribePackageOperation.addValues(result, "Valid", pkg.isValid());
            Pair<Boolean, Boolean> pkgState = this.getState(pkg.getFullName());
            DescribePackageOperation.addValues(result, "Registered", pkgState.first);
            DescribePackageOperation.addValues(result, "Loaded", pkgState.second);
        }
        return new SLResponse(result);
    }

    private Pair<Boolean, Boolean> getState(String pkgFullName) throws Exception {
        if (((RuntimeContext)this.callable).getPackageManifestManager().existsPackage(pkgFullName)) {
            return new Pair<Boolean, Boolean>(true, ((RuntimeContext)this.callable).getPackageManifestManager().isPackageLoaded(pkgFullName));
        }
        for (PackageManifestManager packageManifestManager : ((RuntimeContext)this.callable).getPackageManifestManager().getComponentManifestManagers()) {
            if (!packageManifestManager.existsPackage(pkgFullName)) continue;
            return new Pair<Boolean, Boolean>(true, packageManifestManager.isPackageLoaded(pkgFullName));
        }
        return new Pair<Boolean, Boolean>(false, false);
    }

    public static class Definition
    extends AbstractPackageOperation.Definition {
        private boolean types;

        public Definition(String packageType, String packageName, boolean types) {
            super(DescribePackageOperation.NAME, packageType, packageName);
            this.types = types;
        }

        public boolean isTypes() {
            return this.types;
        }
    }
}

