/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.ComponentManifestManager;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DescribePackageManifestOperation
extends AbstractPackageOperation {
    public static final String NAME = "describe package manifest";

    public DescribePackageManifestOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE PACKAGE MANIFEST");
        this.syntax.addModifier(new Modifier("FOR SERVICES", false));
        this.syntax.setDescription("Shows a list of all packages registered in Runtime Package Manifest.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("FOR SERVICES"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result;
        Definition definition = (Definition)statement;
        if (definition.forServices) {
            result = new RowSet(DescribePackageManifestOperation.createResultDescriptorForServices());
            TreeMap<String, Set> manifestsByServiceType = new TreeMap<String, Set>();
            this.getServiceManifestManagers().forEach(manifest -> manifestsByServiceType.computeIfAbsent(manifest.getComponent().getType(), k -> new TreeSet<ComponentManifestManager>(Comparator.comparing(cmm -> cmm.getComponent().getName()))).add(manifest));
            manifestsByServiceType.forEach((key, value) -> value.forEach(manifest -> DescribePackageManifestOperation.addServicePackages(manifest, this.getPackageObject(Package.getFullName(PackageType.service, key)), result)));
        } else {
            result = new RowSet(DescribePackageManifestOperation.createResultDescriptor());
            int nPackages = DescribePackageManifestOperation.addPackages(((RuntimeContext)this.callable).getPackageManifestManager(), result);
            HashSet addedPackages = new HashSet();
            this.getServiceManifestManagers().forEach(manifest -> this.addServicePackages((ComponentManifestManager)manifest, nPackages + 1, addedPackages, result));
        }
        return new SLResponse(result);
    }

    private static int addPackages(PackageManifestManager manifest, RowSet result) {
        List<PackageDescriptor> packages = manifest.getPackages();
        packages.forEach(pkg -> DescribePackageManifestOperation.addPackage(manifest, pkg, null, null, result));
        return packages.size();
    }

    private void addServicePackages(ComponentManifestManager manifest, Integer position, Set<String> addedPackages, RowSet result) {
        String pkgFullName = Package.getFullName(PackageType.service, manifest.getComponent().getType());
        for (PackageDescriptor descriptor : manifest.getPackages()) {
            if (addedPackages != null && addedPackages.contains(descriptor.getPackageName())) continue;
            Package pkg = this.getPackageObject(pkgFullName);
            DescribePackageManifestOperation.addPackage(manifest, descriptor, position, pkg != null ? pkg.listDependencies() : null, result);
            if (addedPackages == null) continue;
            addedPackages.add(descriptor.getPackageName());
        }
    }

    private static void addPackage(PackageManifestManager manifest, PackageDescriptor descriptor, Integer position, List<String> dependencies, RowSet result) {
        DescribePackageManifestOperation.addValues(result, position == null ? manifest.getPackagePosition(descriptor) : position.intValue(), descriptor.getFullName(), descriptor.isGlobal(), descriptor.isAutoload(), manifest.isPackageLoaded(descriptor.getFullName()), descriptor.isValid(), dependencies != null ? dependencies : "n/a");
    }

    private static void addServicePackages(ComponentManifestManager manifest, Package pkg, RowSet result) {
        manifest.getPackages().forEach(descriptor -> DescribePackageManifestOperation.addValues(result, manifest.getComponentName(), pkg.getFullName(), manifest.isPackageLoaded(descriptor.getFullName()), descriptor.isValid(), pkg != null ? pkg.listDependencies() : "n/a"));
    }

    private Package getPackageObject(String pkgName) {
        try {
            return ((RuntimeContext)this.callable).getRepositoryAccessor().getPackage(pkgName);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribePackageManifestOperation.addColumn(result, "Sequence");
        DescribePackageManifestOperation.addColumn(result, "Package Name");
        DescribePackageManifestOperation.addColumn(result, "Global");
        DescribePackageManifestOperation.addColumn(result, "Autoload");
        DescribePackageManifestOperation.addColumn(result, "Loaded");
        DescribePackageManifestOperation.addColumn(result, "Valid");
        DescribePackageManifestOperation.addColumn(result, "Dependencies");
        return result;
    }

    static RowMetaData createResultDescriptorForServices() {
        RowMetaData result = new RowMetaData();
        DescribePackageManifestOperation.addColumn(result, "Service Name");
        DescribePackageManifestOperation.addColumn(result, "Package Name");
        DescribePackageManifestOperation.addColumn(result, "Loaded");
        DescribePackageManifestOperation.addColumn(result, "Valid");
        DescribePackageManifestOperation.addColumn(result, "Dependencies");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        boolean forServices = false;

        public Definition(boolean forServices) {
            super(DescribePackageManifestOperation.NAME);
            this.forServices = forServices;
        }
    }
}

