/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class CreatePackageOperation
extends AbstractPackageOperation {
    public static final String NAME = "create package";

    public CreatePackageOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE PACKAGE").addActionParameter(new AbstractPackageOperation.PackageTypeNameParameter());
        this.syntax.addModifier(new AbstractPackageOperation.PackageDescriptionModifier());
        this.syntax.addModifier(new AbstractPackageOperation.PackageArchivesModifier(false));
        this.syntax.addModifier(new AbstractPackageOperation.PackageGlobalModifier());
        this.syntax.addModifier(new AbstractPackageOperation.PackageAutoloadModifier());
        this.syntax.addModifier(new AbstractPackageOperation.PackageDependenciesModifier(false));
        this.syntax.setDescription("Creates a new package with the specified parameters.\n" + CreatePackageOperation.getSupportedTypes());
        this.syntax.setExamples("create package service.TestPackage\ncreate package service.TestPackage description 'Test'\ncreate package service.TestPackage archives(test1.jar, test2.jar)\ncreate package service.TestPackage dependencies(sdo.Test1, sdo.Test2)\ncreate package collection.TestPackage global true\ncreate package collection.TestPackage autoload true");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.parsePackageSyntax(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        definition.checkGlobal();
        Package pkg = Package.create(CreatePackageOperation.getType(definition.packageType), definition.packageName, definition.autoload, definition.global);
        if (definition.description != null) {
            pkg.setDescription(definition.description);
        }
        if (!definition.archives.isEmpty()) {
            for (String file : definition.archives) {
                pkg.addJAR(file);
            }
        }
        if (!definition.dependencies.isEmpty()) {
            for (Pair dependency : definition.dependencies) {
                pkg.addDependency((PackageType)((Object)dependency.first), (String)dependency.second);
            }
        }
        ((RuntimeContext)this.callable).getRepositoryAccessor().addPackage(pkg);
        return new SLResponse();
    }

    @Override
    protected AbstractPackageOperation.PackageDefinition createPackageDefinition(String packageType, String packageName) {
        return new Definition(packageType, packageName);
    }

    static class Definition
    extends AbstractPackageOperation.PackageDefinition {
        Definition(String packageType, String packageName) {
            super(CreatePackageOperation.NAME, packageType, packageName);
        }
    }
}

