/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.runtime.mf.operation.repository.AbstractAnalyzeDependenciesOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AnalyzePackageDependenciesOperation
extends AbstractPackageOperation {
    public static final String NAME = "analyze package";

    public AnalyzePackageDependenciesOperation() {
        this.createDSLSyntax(NAME);
        AbstractAnalyzeDependenciesOperation.fillSyntax(this.syntax, "package", new AbstractPackageOperation.PackageTypeNameParameter());
        this.syntax.setDescription("Shows dependencies of the specified package.");
        this.syntax.addCompletionCommand("list packages");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        AnalyzePackageDependenciesOperation.fillAllPackages((RuntimeContext)this.callable, completions);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AnalyzePackageDependenciesOperation.getPackageType(statement), AnalyzePackageDependenciesOperation.getPackageName(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Package pkg = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackage(AnalyzePackageDependenciesOperation.getType(definition.packageType), definition.packageName);
        RowSet result = new RowSet(AnalyzePackageDependenciesOperation.createSimpleResultDescriptor());
        SemanticUtils.ArchiveDependencies dependencies = SemanticUtils.getPackageDependencies(pkg, (RuntimeContext)this.callable);
        AnalyzePackageDependenciesOperation.add(result, new Object[]{"Depends On Ext Archives", dependencies.backwardExt});
        AnalyzePackageDependenciesOperation.add(result, new Object[]{"Depends Packages", this.getPackageNames(dependencies.backwardLib)});
        AnalyzePackageDependenciesOperation.add(result, new Object[]{"Dependent Ext Archives", dependencies.forwardExt});
        AnalyzePackageDependenciesOperation.add(result, new Object[]{"Dependent Packages", this.getPackageNames(dependencies.forwardLib)});
        return new SLResponse(result);
    }

    private List<String> getPackageNames(Set<String> archiveNames) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (String archiveName : archiveNames) {
            Package pkg = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackageByArchive(archiveName);
            if (pkg == null) continue;
            result.add(pkg.getFullName());
        }
        return result;
    }

    public static class Definition
    extends AbstractPackageOperation.Definition {
        public Definition(String packageType, String packageName) {
            super(AnalyzePackageDependenciesOperation.NAME, packageType, packageName);
        }
    }
}

