/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeManifestManager;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.List;

public class AlterPackageOperation
extends AbstractPackageOperation {
    public static final String NAME = "alter package";

    public AlterPackageOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER PACKAGE").addActionParameter(new AbstractPackageOperation.PackageTypeNameParameter());
        this.syntax.addModifier(new AbstractPackageOperation.PackageDescriptionModifier());
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("CLEAR ARCHIVES"))).addModifier(new AbstractPackageOperation.PackageArchivesModifier(true)));
        this.syntax.addModifier(new AbstractPackageOperation.PackageGlobalModifier());
        this.syntax.addModifier(new AbstractPackageOperation.PackageAutoloadModifier());
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("CLEAR DEPENDENCIES"))).addModifier(new AbstractPackageOperation.PackageDependenciesModifier(true)));
        this.syntax.setDescription("Alters the specified package with the specified parameters.\n" + AlterPackageOperation.getSupportedTypes() + "\nParameter 'global' cannot be specified with other parameters.");
        this.syntax.setExamples("alter package service.TestPackage description 'Test'\nalter package service.TestPackage archives(test1.jar, test2.jar)\nalter package service.TestPackage description 'Test' archives(test1.jar, test2.jar)\nalter package service.TestPackage dependencies(sdo.Test1, sdo.Test2)\nalter package collection.TestPackage global true\nalter package collection.TestPackage autoload true");
        this.syntax.addCompletionCommand("list packages");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.fillAllPackages(completions);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = (Definition)this.parsePackageSyntax(statement);
        if (statement.existsModifier("CLEAR ARCHIVES")) {
            definition.clearArchives = true;
        }
        if (statement.existsModifier("CLEAR DEPENDENCIES")) {
            definition.clearDependencies = true;
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        definition.checkGlobal();
        PackageType packageType = AlterPackageOperation.getType(definition.packageType);
        String fullPackageName = Package.getFullName(packageType, definition.packageName);
        RuntimeManifestManager manifestManager = ((RuntimeContext)this.callable).getPackageManifestManager();
        if (definition.global != null && manifestManager.existsPackage(fullPackageName)) {
            if (definition.description != null || !definition.archives.isEmpty() || definition.autoload != null || !definition.dependencies.isEmpty()) {
                throw new ParsingException(this.getSyntaxErrorMessage("Parameter 'global' cannot be specified with other parameters."));
            }
            manifestManager.setPackageScope(fullPackageName, definition.isGlobal());
        } else {
            if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsPackage(packageType, definition.packageName)) {
                throw new Exception("Package not found.");
            }
            if (((RuntimeContext)this.callable).getPackageManifestManager().isPackageLoaded(fullPackageName)) {
                throw new Exception("Package is loaded and cannot be changed.");
            }
            Package pkg = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackage(packageType, definition.packageName);
            if (definition.description != null) {
                pkg.setDescription(definition.description);
            }
            if (definition.clearArchives) {
                pkg.clearJARs();
            }
            if (!definition.archives.isEmpty()) {
                pkg.clearJARs();
                definition.archives.forEach(pkg::addJAR);
            }
            if (definition.global != null) {
                AlterPackageOperation.setGlobal(pkg, definition.global);
            }
            if (definition.autoload != null) {
                AlterPackageOperation.setAutoload(pkg, definition.autoload);
            }
            if (definition.clearDependencies) {
                pkg.clearDependencies();
            }
            if (!definition.dependencies.isEmpty()) {
                pkg.clearDependencies();
                definition.dependencies.forEach(dependency -> pkg.addDependency((PackageType)((Object)((Object)dependency.first)), (String)dependency.second));
            }
            ((RuntimeContext)this.callable).getPackageManifestManager().updatePackage(null, pkg);
        }
        return new SLResponse();
    }

    @Override
    protected AbstractPackageOperation.PackageDefinition createPackageDefinition(String packageType, String packageName) {
        return new Definition(packageType, packageName);
    }

    static class Definition
    extends AbstractPackageOperation.PackageDefinition {
        boolean clearArchives;
        boolean clearDependencies;

        Definition(String packageType, String packageName) {
            super(AlterPackageOperation.NAME, packageType, packageName);
        }
    }
}

