/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.List;

public class AlterPackageManifestOperation
extends AbstractPackageOperation {
    public static final String NAME = "alter package manifest";

    public AlterPackageManifestOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER PACKAGE MANIFEST").addActionParameter(new AbstractPackageOperation.PackageTypeNameParameter());
        this.syntax.addModifier(new AbstractPackageOperation.PackageAutoloadModifier());
        this.syntax.addModifier(new AbstractPackageOperation.PackageSequenceModifier());
        this.syntax.addModifier(new AbstractPackageOperation.PackageGlobalModifier());
        this.syntax.setDescription("Alters the specified package in the Runtime Package Manifest.\n" + AlterPackageManifestOperation.getSupportedTypes() + "\nParameter 'global' cannot be specified with other parameters.");
        this.syntax.setExamples("alter package manifest service.TestPackage autoload true\nalter package manifest service.TestPackage sequence 1\nalter package manifest service.TestPackage autoload true sequence 1\nalter package manifest sdo.TestPackage global false");
        this.syntax.addCompletionCommand("list packages");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.fillRegisteredPackages(completions);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        AbstractPackageOperation.ManifestDefinition definition = this.parseManifestSyntax(statement, null);
        if (definition.global != null && (definition.autoload != null || definition.sequence != null)) {
            throw new ParsingException(this.getSyntaxErrorMessage("Parameter 'global' cannot be specified with other parameters."));
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.doUpdatePackageManifest((Definition)statement, ((RuntimeContext)this.callable).getPackageManifestManager());
        return new SLResponse();
    }

    @Override
    protected AbstractPackageOperation.ManifestDefinition createManifestDefinition(String packageType, String packageName) {
        return new Definition(packageType, packageName);
    }

    public static class Definition
    extends AbstractPackageOperation.ManifestDefinition {
        public Definition(String packageType, String packageName) {
            super(AlterPackageManifestOperation.NAME, packageType, packageName);
        }

        public Definition(String packageType, String packageName, boolean autoload, boolean global, int sequence) {
            super(AlterPackageManifestOperation.NAME, packageType, packageName, autoload, global, sequence);
        }
    }
}

