/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.Trace;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.pkg.ComponentPackageManifest;
import com.streamscape.sef.pkg.PackageManifestException;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.CompoundParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public abstract class AbstractServicePackageOperation
extends AbstractPackageOperation {
    protected void saveManifest(ComponentPackageManifest manifest, String type, String name) throws PackageManifestException {
        AbstractServicePackageOperation.saveManifest((FabricComponent)this.callable, manifest, type, name);
    }

    public static void saveManifest(FabricComponent context, ComponentPackageManifest manifest, String type, String name) throws PackageManifestException {
        try {
            SemanticObjectReferenceStore.beginXact(context);
            ReferenceContext ref = SemanticObjectReferenceStore.lookupReferenceContext("/sys/package/manifest/" + type);
            if (ref == null) {
                ref = SemanticObjectReferenceStore.createSubcontextFromNamespace("/sys/package/manifest/" + type);
                Trace.logDebug(AbstractServicePackageOperation.class, "Component Package Manifest area not found. Recreation...");
            }
            SemanticObjectReferenceStore.setReferenceContext(ref);
            if (SemanticObjectReferenceStore.lookup(name) == null) {
                Trace.logDebug(AbstractServicePackageOperation.class, "Creating Package Manifest for '" + type + "." + name + "'...");
                SemanticObjectReferenceStore.bind(name, manifest);
            } else {
                Trace.logDebug(AbstractServicePackageOperation.class, "Updating Package Manifest for '" + type + "." + name + "'...");
                SemanticObjectReferenceStore.rebind(name, manifest);
            }
            SemanticObjectReferenceStore.commitXact();
        }
        catch (ObjectConfigurationException exception) {
            throw new PackageManifestException("Saving of Component Package Manifest failed.", exception);
        }
    }

    protected ComponentPackageManifest loadManifest(String type, String name) throws PackageManifestException {
        return AbstractServicePackageOperation.loadManifest((FabricComponent)this.callable, type, name);
    }

    public static ComponentPackageManifest loadManifest(FabricComponent context, String type, String name) throws PackageManifestException {
        try {
            ReferenceContext ref = SemanticObjectReferenceStore.lookupReferenceContext("/sys/package/manifest/" + type);
            if (ref != null) {
                SemanticObjectReferenceStore.beginXact(context);
                SemanticObjectReferenceStore.setReferenceContext(ref);
                ComponentPackageManifest manifest = (ComponentPackageManifest)SemanticObjectReferenceStore.lookup(name);
                SemanticObjectReferenceStore.commitXact();
                return manifest;
            }
            return null;
        }
        catch (ObjectConfigurationException exception) {
            throw new PackageManifestException("Loading of Component Package Manifest failed.", exception);
        }
    }

    protected String getServiceType(DSLStatement statement) {
        return statement.getParameter("ServiceType").getValue();
    }

    protected String getServiceName(DSLStatement statement) {
        return statement.getParameter("ServiceName").getValue();
    }

    protected ServiceManifestDefinition createServiceManifestDefinition(String serviceType, String serviceName, String packageType, String packageName) {
        return null;
    }

    protected ServiceManifestDefinition parseServiceManifestSyntax(DSLStatement statement, AbstractPackageOperation.ManifestDefinition result) throws ParsingException {
        if (result == null) {
            result = this.createServiceManifestDefinition(this.getServiceType(statement), this.getServiceName(statement), AbstractServicePackageOperation.getPackageType(statement), AbstractServicePackageOperation.getPackageName(statement));
        }
        return (ServiceManifestDefinition)this.parseManifestSyntax(statement, result);
    }

    public static class ServiceManifestDefinition
    extends AbstractPackageOperation.ManifestDefinition {
        private String serviceType;
        private String serviceName;

        public ServiceManifestDefinition(String name, String serviceType, String serviceName, String packageType, String packageName) {
            super(name, packageType, packageName);
            this.serviceType = serviceType;
            this.serviceName = serviceName;
        }

        public ServiceManifestDefinition(String name, String serviceType, String serviceName, String packageType, String packageName, boolean autoload, int sequence) {
            super(name, packageType, packageName, autoload, false, sequence);
            this.serviceType = serviceType;
            this.serviceName = serviceName;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public String getServiceName() {
            return this.serviceName;
        }
    }

    public static class ForServiceTypeNameModifier
    extends Modifier {
        ForServiceTypeNameModifier() {
            super("FOR");
            this.addParameter(new ServiceTypeNameParameter());
            this.setSyntaxHint(SyntaxHint.SPACE);
        }
    }

    public static class ServiceTypeNameParameter
    extends CompoundParameter {
        ServiceTypeNameParameter() {
            this("ServiceType", "ServiceName");
        }

        ServiceTypeNameParameter(String serviceTypeName, String serviceNameName) {
            this.setParametersDelimiter('.');
            this.addParameter((AbstractParameter)new IdentifierParameter("ServiceType").setName(serviceTypeName));
            this.addParameter((AbstractParameter)new IdentifierParameter("ServiceName").setName(serviceNameName));
        }
    }
}

