/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.pkg;

import com.streamscape.Trace;
import com.streamscape.lib.utils.Pair;
import com.streamscape.omf.java.Utils;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.repository.AbstractRepositoryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.ComponentManifestManager;
import com.streamscape.sef.enums.ComponentModel;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.BooleanParameter;
import com.streamscape.slex.lang.parameter.CompoundParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.NumericParameter;
import com.streamscape.slex.lang.parameter.RegexpValidator;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingException;

public abstract class AbstractPackageOperation
extends AbstractRepositoryOperation {
    protected AbstractPackageOperation() {
    }

    protected AbstractPackageOperation(boolean isAdministrative) {
        super(isAdministrative);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.pkg);
    }

    protected void addNovalidateModifier() {
        this.syntax.addModifier(new Modifier("NO VALIDATE", false));
    }

    protected static PackageType getType(String type) throws FabricException {
        try {
            return PackageType.valueOf(type.toLowerCase());
        }
        catch (Exception exception) {
            throw new FabricException("Type '" + type + "' is not supported.");
        }
    }

    protected static String getSupportedTypes() {
        return "The following package types are supported: " + String.valueOf((Object)PackageType.client) + ", " + String.valueOf((Object)PackageType.collection) + ", " + String.valueOf((Object)PackageType.jdbc) + ", " + String.valueOf((Object)PackageType.sdo) + ", " + String.valueOf((Object)PackageType.service) + ", " + String.valueOf((Object)PackageType.transport) + ".";
    }

    protected void doRegisterPackage(ManifestDefinition definition, PackageManifestManager manifestManager) throws Exception {
        definition.checkGlobal();
        PackageType pkgType = AbstractPackageOperation.getType(definition.getPackageType());
        Package pkg = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackage(pkgType, definition.getPackageName());
        PackageDescriptor descriptor = PackageDescriptor.create(pkg, definition.autoload, definition.global);
        if (definition.getSequence() != -1) {
            manifestManager.addPackageAt(definition.getSequence(), descriptor);
        } else {
            manifestManager.addPackage(descriptor);
        }
    }

    protected void doUpdatePackageManifest(ManifestDefinition definition, PackageManifestManager manifestManager) throws Exception {
        definition.checkGlobal();
        String fullPackageName = definition.getPackageType() + "." + definition.getPackageName();
        if (definition.global != null) {
            manifestManager.setPackageScope(fullPackageName, definition.isGlobal());
        } else {
            PackageDescriptor descriptor = manifestManager.getPackage(fullPackageName);
            if (descriptor == null) {
                throw new Exception("Package '" + fullPackageName + "' is not registered.");
            }
            if (definition.autoload != null) {
                descriptor.setAutoload(definition.autoload);
            }
            if (definition.getSequence() != null) {
                manifestManager.updatePackageAt(definition.getSequence(), descriptor, null);
            } else {
                manifestManager.updatePackage(descriptor, null);
            }
        }
    }

    protected ManifestDefinition createManifestDefinition(String packageType, String packageName) {
        return null;
    }

    protected ManifestDefinition parseManifestSyntax(DSLStatement statement, ManifestDefinition result) throws ParsingException {
        if (result == null) {
            result = this.createManifestDefinition(AbstractPackageOperation.getPackageType(statement), AbstractPackageOperation.getPackageName(statement));
        }
        if (statement.existsParameter("Autoload")) {
            result.autoload = Boolean.parseBoolean(statement.getParameter("Autoload").getValue());
        }
        if (statement.existsParameter("Global")) {
            result.global = Boolean.parseBoolean(statement.getParameter("Global").getValue());
        }
        if (statement.existsParameter("LoadSequence")) {
            result.sequence = Integer.parseInt(statement.getParameter("LoadSequence").getValue());
        }
        return result;
    }

    protected PackageDefinition createPackageDefinition(String packageType, String packageName) {
        return null;
    }

    protected static String getPackageType(DSLStatement statement) {
        return statement.getParameter("PackageType").getValue();
    }

    protected static String getPackageName(DSLStatement statement) {
        return statement.getParameter("PackageName").getValue();
    }

    protected PackageDefinition parsePackageSyntax(DSLStatement statement) throws ParsingException {
        StatementSetValue dependencies;
        StatementSetValue archives;
        PackageDefinition result = this.createPackageDefinition(AbstractPackageOperation.getPackageType(statement), AbstractPackageOperation.getPackageName(statement));
        if (statement.existsParameter("Description")) {
            result.description = statement.getParameter("Description").getValue();
        }
        if ((archives = statement.getSet("ArchivesSet")).isPresent()) {
            for (int i = 0; i < archives.size(); ++i) {
                result.addArchive(archives.getElement(i).getParameter("Archive").getValue());
            }
        }
        if (statement.existsParameter("Global")) {
            result.global = Boolean.parseBoolean(statement.getParameter("Global").getValue());
        }
        if (statement.existsParameter("Autoload")) {
            result.autoload = Boolean.parseBoolean(statement.getParameter("Autoload").getValue());
        }
        if ((dependencies = statement.getSet("DependenciesSet")).isPresent()) {
            for (int i = 0; i < dependencies.size(); ++i) {
                try {
                    result.addDependency(Package.parseFullName(dependencies.getElement(i).getParameter("Dependency").getValue()));
                    continue;
                }
                catch (NamingException exception) {
                    throw new ParsingException(exception.getMessage());
                }
            }
        }
        return result;
    }

    protected static void fillAllPackages(RuntimeContext callable, List<String> result) {
        try {
            List<String> packages = callable.getRepositoryAccessor().listPackages();
            Collections.sort(packages);
            result.addAll(packages);
        }
        catch (Exception exception) {
            Trace.logException(AbstractPackageOperation.class, exception, false);
        }
    }

    protected void fillAllPackages(List<String> result) {
        AbstractPackageOperation.fillAllPackages((RuntimeContext)this.callable, result);
    }

    protected void fillLoadedPackages(List<String> packages) {
        ArrayList<String> registered = new ArrayList<String>();
        this.fillRegisteredPackages(registered);
        for (String pkg : registered) {
            if (!((RuntimeContext)this.callable).getPackageManifestManager().isPackageLoaded(pkg)) continue;
            packages.add(pkg);
        }
    }

    protected void fillUnLoadedPackages(List<String> packages) {
        ArrayList<String> registered = new ArrayList<String>();
        this.fillRegisteredPackages(registered);
        for (String pkg : registered) {
            if (((RuntimeContext)this.callable).getPackageManifestManager().isPackageLoaded(pkg)) continue;
            packages.add(pkg);
        }
    }

    protected void fillRegisteredPackages(List<String> packages) {
        packages.addAll(((RuntimeContext)this.callable).getPackageManifestManager().listPackages());
    }

    protected void fillUnregisteredPackages(List<String> result) {
        try {
            List<String> packages = ((RuntimeContext)this.callable).getRepositoryAccessor().listPackages();
            Collections.sort(packages);
            for (String pkgName : packages) {
                Pair<PackageType, String> fullPkgName = Package.parseFullName(pkgName);
                if (fullPkgName.first == PackageType.service || ((RuntimeContext)this.callable).getPackageManifestManager().existsPackage(pkgName)) continue;
                result.add(pkgName);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    protected static String formatTimestamp(Package pkg) {
        return pkg.getTimestamp() > 0L ? AbstractOperation.formatDate(pkg.getTimestamp()) : "n/a";
    }

    protected void checkDependentPackages(String pkgFullName, MFSession session) {
        for (ComponentManifestManager manifestManager : this.getServiceManifestManagers()) {
            try {
                Package pkg = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackage(PackageType.service, manifestManager.getComponent().getType());
                if (!pkg.listDependencies().contains(pkgFullName)) continue;
                this.raiseSLMessage("\nWARNING: Package Dependency (" + pkgFullName + " -> " + pkg.getFullName() + ") detected. Service '" + ModeratorUtils.makeComponentFullName(manifestManager.getComponent()) + "' may be affected.", session);
            }
            catch (Exception exception) {}
        }
        Utils.sleep(100L);
    }

    protected List<ComponentManifestManager> getServiceManifestManagers() {
        return ((RuntimeContext)this.callable).getPackageManifestManager().getComponentManifestManagers(ComponentModel.CTX_SERVICE);
    }

    protected static class ManifestDefinition
    extends Definition {
        Integer sequence;

        protected ManifestDefinition(String name, String packageType, String packageName) {
            super(name, packageType, packageName);
        }

        protected ManifestDefinition(String name, String packageType, String packageName, boolean autoload, boolean global, int sequence) {
            super(name, packageType, packageName);
            this.autoload = autoload;
            this.global = global;
            this.sequence = sequence;
        }

        public Integer getSequence() {
            return this.sequence == null ? -1 : this.sequence;
        }
    }

    protected static class PackageDefinition
    extends Definition {
        String description;
        List<String> archives = new ArrayList<String>();
        List<Pair<PackageType, String>> dependencies = new ArrayList<Pair<PackageType, String>>();

        PackageDefinition(String name, String packageType, String packageName) {
            super(name, packageType, packageName);
        }

        PackageDefinition(String name, String packageType, String packageName, String description) {
            super(name, packageType, packageName);
            this.description = description;
        }

        void addArchive(String archive) {
            this.archives.add(archive);
        }

        void addDependency(Pair<PackageType, String> pkgFullName) {
            this.dependencies.add(pkgFullName);
        }
    }

    protected static class LoadUnloadDefinition
    extends Definition {
        public boolean noValidate;

        protected LoadUnloadDefinition(String name, String packageType, String packageName, boolean noValidate) {
            super(name, packageType, packageName);
            this.noValidate = noValidate;
        }
    }

    protected static class Definition
    extends AbstractSLStatement {
        String packageType;
        String packageName;
        Boolean global;
        Boolean autoload;

        Definition(String name, String packageType, String packageName) {
            super(name);
            this.packageType = packageType;
            this.packageName = packageName;
        }

        public String getPackageType() {
            return this.packageType;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public boolean isGlobal() {
            return this.global != null && this.global != false;
        }

        public void checkGlobal() throws Exception {
            PackageType type = AbstractPackageOperation.getType(this.packageType);
            if (this.global != null && this.global.booleanValue() && !Package.isGeneric(type)) {
                throw new Exception("Only SDO or Collection packages can be global.");
            }
        }
    }

    public static class PackageDependenciesModifier
    extends Modifier {
        public PackageDependenciesModifier(boolean required) {
            super("DEPENDENCIES");
            this.addParameter(new SetParameter("DependenciesSet").addParameter((AbstractParameter)new PackageTypeNameParameter("DependencyType", "DependencyName").setName("Dependency")));
            this.setRequired(required);
        }
    }

    public static class PackageSequenceModifier
    extends Modifier {
        public PackageSequenceModifier() {
            super("SEQUENCE");
            this.addParameter(new NumericParameter("LoadSequence"));
            this.setRequired(false);
        }
    }

    public static class PackageGlobalModifier
    extends Modifier {
        public PackageGlobalModifier() {
            super("GLOBAL");
            this.addParameter(new BooleanParameter("Global"));
            this.setRequired(false);
        }
    }

    public static class PackageAutoloadModifier
    extends Modifier {
        public PackageAutoloadModifier() {
            super("AUTOLOAD");
            this.addParameter(new BooleanParameter("Autoload"));
            this.setRequired(false);
        }
    }

    public static class PackageArchivesModifier
    extends Modifier {
        public PackageArchivesModifier(boolean required) {
            super("ARCHIVES");
            this.addParameter(new SetParameter("ArchivesSet").addParameter((AbstractParameter)new ExpressionParameter("Archive1").setName("Archive")));
            this.setRequired(required);
        }
    }

    public static class PackageDescriptionModifier
    extends Modifier {
        public PackageDescriptionModifier() {
            super("DESCRIPTION");
            this.addParameter(new StringParameter("Description", Character.valueOf('\''), Character.valueOf('\'')));
            this.setRequired(false);
        }
    }

    public static class PackageTypeNameParameter
    extends CompoundParameter {
        public PackageTypeNameParameter() {
            this("PackageType", "PackageName");
        }

        public PackageTypeNameParameter(String packageTypeName, String packageNameName) {
            super("PackageTypeNameParameter");
            StringBuilder packageTypeRegexp = new StringBuilder();
            packageTypeRegexp.append("(?i)(");
            packageTypeRegexp.append((Object)PackageType.client).append("|");
            packageTypeRegexp.append((Object)PackageType.collection).append("|");
            packageTypeRegexp.append((Object)PackageType.jdbc).append("|");
            packageTypeRegexp.append((Object)PackageType.sdo).append("|");
            packageTypeRegexp.append((Object)PackageType.service).append("|");
            packageTypeRegexp.append((Object)PackageType.transport).append(")");
            this.setParametersDelimiter('.');
            this.addParameter((AbstractParameter)((IdentifierParameter)new IdentifierParameter("PackageType").setName(packageTypeName)).setValueValidator(new RegexpValidator(packageTypeRegexp.toString())));
            this.addParameter((AbstractParameter)new IdentifierParameter("PackageName").setName(packageNameName));
        }
    }
}

