/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractModeratorOperation;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.LongParameter;

public class ShutdownOperation
extends AbstractModeratorOperation {
    public static final String NAME = "shutdown";

    public ShutdownOperation(boolean mnode) {
        super(true, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHUTDOWN");
        this.syntax.addModifier(new Modifier("CHECKPOINT", false));
        this.syntax.addModifier((AbstractModifier)new Modifier("WITH TIMEOUT", false).addParameter(new LongParameter("Timeout")));
        if (mnode) {
            this.syntax.addModifier(new ChoiceModifier(false).addPossibleValues("ALL", "RESTART"));
        }
        this.syntax.setDescription("Initiates shutdown of the node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   checkpoint             - Invokes SLANG command 'checkpoint' before shutdown of the node.\n   with timeout <Timeout> - Wait time (in seconds) for normal shutdown of the node.\n                            If the timeout expires before shutdown completion, the node forcibly detaches from the sysplex.\n                            Non-positive value means that forced detaching will not be used. Default is 10 seconds." + (mnode ? "\n   all                    - Shutdowns the associated Activator.\n   restart                - Restarts the node after shutdown." : ""));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("CHECKPOINT"), statement.existsParameter("Timeout") ? Long.valueOf(Long.parseLong(statement.getParameter("Timeout").getValue())) : null, statement.existsModifier("ALL") ? ShutdownMode.ALL : (statement.existsModifier("RESTART") ? ShutdownMode.RESTART : null));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.checkpoint) {
            ((RuntimeContext)this.callable).getLexiconProcessor().invoke("checkpoint", session, 10000L);
        }
        if (definition.timeout != null) {
            RuntimeContext.getInstance().setShutdownTimeout(definition.timeout);
        }
        if (definition.shutdownMode != null) {
            if (((RuntimeContext)this.callable).getModerator().getFabricNode().getRole() != FabricNodeRole.MANAGEMENT_NODE) {
                throw new Exception(String.valueOf((Object)definition.shutdownMode) + " option is applicable for management nodes only.");
            }
            if (definition.shutdownMode == ShutdownMode.ALL) {
                ((RuntimeContext)this.callable).shutdownAll();
            } else {
                ((RuntimeContext)this.callable).restart();
            }
        } else {
            ((RuntimeContext)this.callable).shutdown();
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private boolean checkpoint;
        private Long timeout;
        private ShutdownMode shutdownMode;

        public Definition(boolean checkpoint, Long timeout, ShutdownMode shutdownMode) {
            super(ShutdownOperation.NAME);
            this.checkpoint = checkpoint;
            this.timeout = timeout;
            this.shutdownMode = shutdownMode;
        }

        public boolean isCheckpoint() {
            return this.checkpoint;
        }

        public Long getTimeout() {
            return this.timeout;
        }

        public ShutdownMode getShutdownMode() {
            return this.shutdownMode;
        }
    }

    public static enum ShutdownMode {
        ALL,
        RESTART;

    }
}

