/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractModeratorOperation;
import com.streamscape.sef.exchange.TopologyLink;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.Comparator;
import java.util.List;

public class ShowTopologyOperation
extends AbstractModeratorOperation {
    public static final String NAME = "show topology";

    public ShowTopologyOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW TOPOLOGY");
        this.syntax.setDescription("Shows the current topology (a list of links between nodes) of the sysplex.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ShowTopologyOperation.createResultDescriptor());
        List<TopologyLink> links = ((RuntimeContext)this.callable).getExchange().getTopology();
        links.sort(Comparator.comparing(TopologyLink::getToNode));
        for (TopologyLink link : links) {
            result.addToRowSet(new Object[]{link.getFromNode(), link.getToNode(), link.getLinkAddress()});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ShowTopologyOperation.addColumn(result, "Source Node");
        ShowTopologyOperation.addColumn(result, "Target Node");
        ShowTopologyOperation.addColumn(result, "Access Point");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ShowTopologyOperation.NAME);
        }
    }
}

