/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.runtime.ConfigurationState;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.StDeployGenerator;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.SetParametersModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.container.FabricContainer;
import com.streamscape.sef.dispatcher.AbstractNodePropertiesOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.tools.mnode.MNodeContainer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SetNodePropertiesOperation
extends AbstractNodePropertiesOperation {
    public static final String NAME = "set node properties";
    private static final String IO_TIMEOUT = "repositoryIoTimeout";
    private static final String LOGGER_MAX_SIZE = "logFileMaxSize";
    private static final String LOGGER_ARCHIVE = "logFileArchive";
    private static final String LOGGER_MAX_FILES = "maximumLogFiles";
    private static final String LOGGER_LOG_ID = "logID";
    private static final String LOGGER_GENERATION = "logGeneration";
    private static final String LOGGER_THRESHOLD = "logThreshold";
    private static final String ACTIVATOR_URL = "activatorUrl";
    private static final String MIN_TLP_PORT = "minimumTlpPort";
    private static final String MAX_TLP_PORT = "maximumTlpPort";
    private static final String MIN_HTTP_PORT = "minimumHttpPort";
    private static final String MAX_HTTP_PORT = "maximumHttpPort";
    private boolean isInitialized = false;

    public SetNodePropertiesOperation(RuntimeContext context) {
        super(true, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET NODE PROPERTIES");
        this.syntax.addModifier((AbstractModifier)new SetParametersModifier("", "Properties").setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Sets the specified properties of the node.");
        this.syntax.addTag(OperationTag.log);
        this.syntax.addTag(OperationTag.sysplex);
    }

    @Override
    public String getSyntax(MFSession session) {
        this.initialize();
        return super.getSyntax(session);
    }

    @Override
    public String getSyntaxDescription(MFSession session) {
        this.initialize();
        return super.getSyntaxDescription(session);
    }

    @Override
    public String getExamples(MFSession session) {
        this.initialize();
        return super.getExamples(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (!this.isInitialized) {
            SetNodePropertiesOperation setNodePropertiesOperation = this;
            synchronized (setNodePropertiesOperation) {
                if (!this.isInitialized) {
                    this.doInitialize();
                    this.isInitialized = true;
                }
            }
        }
    }

    private void doInitialize() {
        this.syntax.setSyntaxDescription("set node properties           - Sets the specified properties in the current node.\nset node properties at node   - Sets the specified properties in the specified node.\nset node properties at domain - Sets the specified properties in all nodes of the sysplex.\n\nThe following properties are supported:\n\n   repositoryIoTimeout - Timeout (in milliseconds) of CacheIOThread in the Repository." + this.getContainerDescription() + this.getMnodeDescription());
        this.syntax.setExamples("set node properties (repositoryIoTimeout = '5000')" + this.getContainerExample() + this.getMnodeExample());
    }

    private String getContainerDescription() {
        if (this.isContainer()) {
            return "\n\n   logFileMaxSize      - Max size (in bytes) of the Trace log. If the log size exceeds this limit, a new log file will be generated.\n                         Non-positive value means that the current log will be of unlimited size.\n   logFileArchive      - Enables or disables archiving of the Trace log if 'logFileMaxSize' is positive.\n                         If disabled, the old log file will be deleted before generating a new one.\n   maximumLogFiles     - Max number of the Trace log files that can be archived if archiving is enabled.\n                         Negative values means that all logs will be archived. Zero value means that no logs will be archived.\n   logID               - Format of the name of the archived Trace log file.\n                         It can be timestamp or sequence. Default is timestamp.\n   logGeneration       - Number of new Trace log files generated, after reaching which the advisory [advisory.log.Generation] is raised.\n                         Negative values means that the advisory will not be raised.\n   logThreshold        - Size of the Trace log file, upon reaching which the advisory [advisory.log.Threshold] is raised.\n                         Threshold is given as a percentage. Non-positive value means that the advisory will not be raised.\n";
        }
        return "";
    }

    private String getContainerExample() {
        if (this.isContainer()) {
            return "\nset node properties (logFileMaxSize = '1048576', logFileArchive = 'true', maximumLogFiles = '5')\nset node properties (logID = 'sequence')";
        }
        return "";
    }

    private boolean isContainer() {
        return ((RuntimeContext)this.callable).getContainer() != null;
    }

    private String getMnodeDescription() {
        if (this.isMnode()) {
            return "\n   activatorUrl        - URL for TLP acceptor of Activator associated with the node.\n                         Changing this property will take effect after restart of the node and associated Activator.\n   minimumTlpPort      - Min TLP port that can be assigned for a new managed node by the 'create managed node' command.\n   maximumTlpPort      - Max TLP port that can be assigned for a new managed node by the 'create managed node' command.\n   minimumHttpPort     - Min HTTP port that can be assigned for a new managed node by the 'create managed node' command.\n   maximumHttpPort     - Max HTTP port that can be assigned for a new managed node by the 'create managed node' command.";
        }
        return "";
    }

    private String getMnodeExample() {
        if (this.isMnode()) {
            return "\nset node properties (activatorUrl = 'tlp://localhost:6667', minimumTlpPort = '6000', maximumTlpPort = '6020')";
        }
        return "";
    }

    private boolean isMnode() {
        return ((RuntimeContext)this.callable).getNodeRole() == FabricNodeRole.MANAGEMENT_NODE;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), SetParametersModifier.getValue(statement, "Properties"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        this.initialize();
        for (Map.Entry<String, String> entry : ((Definition)statement).properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue(), ((RuntimeContext)this.callable).getContainer());
        }
        return new SLResponse();
    }

    private void setProperty(String name, String value, FabricContainer container) throws Exception {
        if (name.equalsIgnoreCase(IO_TIMEOUT)) {
            this.setIoTimeout(value, SetParametersModifier.getLong(name, value));
        } else if (name.equalsIgnoreCase(LOGGER_MAX_SIZE)) {
            SetNodePropertiesOperation.checkContainer(container, LOGGER_MAX_SIZE);
            container.getLoggerParameters().setMaxSize(SetParametersModifier.getLong(name, value));
        } else if (name.equalsIgnoreCase(LOGGER_ARCHIVE)) {
            SetNodePropertiesOperation.checkContainer(container, LOGGER_ARCHIVE);
            container.getLoggerParameters().setArchive(SetParametersModifier.getBoolean(name, value));
        } else if (name.equalsIgnoreCase(LOGGER_MAX_FILES)) {
            SetNodePropertiesOperation.checkContainer(container, LOGGER_MAX_FILES);
            container.getLoggerParameters().setMaxFiles(SetParametersModifier.getInt(name, value));
        } else if (name.equalsIgnoreCase(LOGGER_LOG_ID)) {
            SetNodePropertiesOperation.checkContainer(container, LOGGER_LOG_ID);
            boolean sequence = false;
            if (value.equalsIgnoreCase("sequence")) {
                sequence = true;
            } else if (!value.equalsIgnoreCase("timestamp")) {
                throw new Exception("Invalid value '" + value + "' for property '" + name + "'. Can be 'sequence' or 'timestamp'.");
            }
            container.getLoggerParameters().setSequence(sequence);
        } else if (name.equalsIgnoreCase(LOGGER_GENERATION)) {
            SetNodePropertiesOperation.checkContainer(container, LOGGER_GENERATION);
            container.getLoggerParameters().setAdvisoryGeneration(SetParametersModifier.getInt(name, value));
        } else if (name.equalsIgnoreCase(LOGGER_THRESHOLD)) {
            SetNodePropertiesOperation.checkContainer(container, LOGGER_THRESHOLD);
            container.getLoggerParameters().setAdvisoryThreshold(SetParametersModifier.getInt(name, value));
        } else if (name.equalsIgnoreCase(ACTIVATOR_URL)) {
            SetNodePropertiesOperation.checkMnode(container, ACTIVATOR_URL);
            if (((MNodeContainer)container).setActivatorURL(SetNodePropertiesOperation.getLink(name, value))) {
                ((RuntimeContext)this.callable).setConfigurationState(ConfigurationState.RESTART_REQUIRED);
            }
        } else if (name.equalsIgnoreCase(MIN_TLP_PORT)) {
            SetNodePropertiesOperation.checkMnode(container, MIN_TLP_PORT);
            ((MNodeContainer)container).setMinTlpPort(SetParametersModifier.getInt(name, value));
        } else if (name.equalsIgnoreCase(MAX_TLP_PORT)) {
            SetNodePropertiesOperation.checkMnode(container, MAX_TLP_PORT);
            ((MNodeContainer)container).setMaxTlpPort(SetParametersModifier.getInt(name, value));
        } else if (name.equalsIgnoreCase(MIN_HTTP_PORT)) {
            SetNodePropertiesOperation.checkMnode(container, MIN_HTTP_PORT);
            ((MNodeContainer)container).setMinHttpPort(SetParametersModifier.getInt(name, value));
        } else if (name.equalsIgnoreCase(MAX_HTTP_PORT)) {
            SetNodePropertiesOperation.checkMnode(container, MAX_HTTP_PORT);
            ((MNodeContainer)container).setMaxHttpPort(SetParametersModifier.getInt(name, value));
        } else {
            throw new FabricException("Unknown property '" + name + "'.");
        }
    }

    private void setIoTimeout(String value, long timeout) throws Exception {
        if (timeout <= 0L) {
            throw new Exception("Parameter 'repositoryIoTimeout' must be positive.");
        }
        this.setCacheIOTimeout(timeout);
        CtxDeploymentDescriptor descriptor = (CtxDeploymentDescriptor)((RuntimeContext)this.callable).getDeploymentDescriptor();
        descriptor.setIOTimeout(value);
        StDeployGenerator.generate(new File(((RuntimeContext)this.callable).getDeploymentDescriptorFilename()), ((RuntimeContext)this.callable).getXSerializer().serialize(descriptor).getBytes());
    }

    private static String getLink(String name, String value) throws Exception {
        try {
            return new LinkAddress((String)(value.contains("://") ? value : FabricConnection.URL_PREFIX + value)).toString();
        }
        catch (Exception exception) {
            throw new FabricException("Invalid value '" + value + "' for property '" + name + "'.", exception);
        }
    }

    private static void checkContainer(FabricContainer container, String parameter) throws Exception {
        if (container == null) {
            throw new FabricException("Container not found. Parameter '" + parameter + "' cannot be set.");
        }
    }

    private static void checkMnode(FabricContainer container, String parameter) throws Exception {
        if (!(container instanceof MNodeContainer)) {
            throw new FabricException("Node is not a Management Node. Parameter '" + parameter + "' cannot be set.");
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private Map<String, String> properties;

        public Definition(String nodeName, Map<String, String> properties) {
            super(SetNodePropertiesOperation.NAME);
            this.nodeName = nodeName;
            this.properties = properties;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public Map<String, String> getProperties() {
            return new HashMap<String, String>(this.properties);
        }
    }
}

