/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.EventFlowMap;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;

public class SelectEventFlowOperation
extends AbstractNodeOperation {
    public static final String NAME = "select event flow";

    public SelectEventFlowOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SELECT EVENT FLOW");
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.addModifier((AbstractModifier)new Modifier("ALL", false).setAlias("*"));
        this.syntax.addModifier(new CompoundModifier("AsFormat", false).addModifier(new Modifier("AS")).addModifier(new ChoiceModifier("Format").addPossibleValues("XML", "JSON")));
        String prefix = "  select event flow";
        this.syntax.setDescription("Returns an object containing event flows for all events in the current node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   at node     - Specifies the node.\n   at domain   - Specifies the whole sysplex.\n   all         - Specifies if system event flows should be included to the result.\n   as xml      - Shows the result object in XML format.\n   as json     - Shows the result object in JSON format.");
        this.syntax.setExamples("select event flow\nselect event flow at node TestNode\nselect event flow all\nselect event flow at domain\nselect event flow at domain all\nselect event flow as XML\nselect event flow at node TestNode as JSON\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(SelectEventFlowOperation.getNodeName(statement), statement.existsModifier("ALL"), statement.existsModifier("XML"), statement.existsModifier("JSON"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        EventFlowMap map;
        Definition definition = (Definition)statement;
        EventFlowMap eventFlowMap = map = Utils.equalsNullSafe(definition.nodeName, "*") ? ((RuntimeContext)this.callable).getModerator().getEventFlowMap(definition.isAll) : this.getNode(definition.nodeName).getEventFlowMap(definition.isAll);
        if (definition.asXML) {
            return new SLResponse(((RuntimeContext)this.callable).getXSerializer().serialize(map));
        }
        if (definition.asJSON) {
            return new SLResponse(((RuntimeContext)this.callable).getJSONSerializer().serialize(map));
        }
        RowSet rowSet = new RowSet(SelectEventFlowOperation.createResultDescriptor());
        SelectEventFlowOperation.addValues(rowSet, map);
        return new SLResponse(rowSet);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        SelectEventFlowOperation.addGenericColumn(result, "Event Flows");
        return result;
    }

    public static class Definition
    extends AbstractNodeOperation.Definition {
        private boolean isAll;
        private boolean asXML;
        private boolean asJSON;

        public Definition(String nodeName, boolean isAll, boolean asXML, boolean asJSON) {
            super(SelectEventFlowOperation.NAME, nodeName);
            this.isAll = isAll;
            this.asXML = asXML;
            this.asJSON = asJSON;
        }

        public boolean isAll() {
            return this.isAll;
        }

        public boolean asXML() {
            return this.asXML;
        }

        public boolean asJSON() {
            return this.asJSON;
        }
    }
}

