/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.ds.replication.ReplicationUtil;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.moderator.AbstractListReplicationEntitiesOperation;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ReplicationSourceReference;
import com.streamscape.slex.MFSession;
import java.util.List;

public class ListReplicationSourcesOperation
extends AbstractListReplicationEntitiesOperation {
    public static final String NAME = "list replication sources";
    static final String[] DESCRIPTOR_ELEMENTS = new String[]{"Collection Name", "Fully Qualified Name", "Event Scope", "Enabled", "Mode", "Total Replicas", "Replica Names"};

    public ListReplicationSourcesOperation() {
        super(NAME);
    }

    @Override
    String getEntityName() {
        return "replication source";
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractNodeOperation.Definition definition = (AbstractNodeOperation.Definition)statement;
        RowSet result = new RowSet(ListReplicationSourcesOperation.createResultDescriptor());
        for (ReplicationSourceReference reference : ListReplicationSourcesOperation.getReplicationSources(this, (RuntimeContext)this.callable, definition.getNodeName(), ListReplicationSourcesOperation.getEventScope(definition, session))) {
            result.addToRowSet(new Object[]{reference.getCollectionName(), reference.getName(), reference.getEventScope(), reference.isEnabled(), reference.isSync() ? "Sync" : "Async", reference.listReplicas().size(), ReplicationUtil.formattedOutputReplicaList(reference.listReplicas(), false)});
        }
        return new SLResponse(result);
    }

    static List<ReplicationSourceReference> getReplicationSources(AbstractListReplicationEntitiesOperation operation, RuntimeContext callable, String nodeName, EventScope eventScope) throws FabricException {
        if (nodeName == null) {
            return callable.getModerator().getFabricNode().getReplicationSources(eventScope);
        }
        if (nodeName.equalsIgnoreCase("*")) {
            return callable.getModerator().getReplicationSources(eventScope);
        }
        return operation.getNode(nodeName).getReplicationSources(eventScope);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        for (String descriptorElement : DESCRIPTOR_ELEMENTS) {
            ListReplicationSourcesOperation.addColumn(result, descriptorElement);
        }
        return result;
    }

    @Override
    public AbstractNodeOperation.Definition createDefinition(String nodeName) {
        return new AbstractNodeOperation.Definition(NAME, nodeName);
    }
}

