/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.moderator.AbstractListReplicationEntitiesOperation;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ReplicationSourceReference;
import com.streamscape.sef.moderator.ReplicationTargetReference;
import com.streamscape.slex.MFSession;
import java.util.List;

public class ListReplicasOperation
extends AbstractListReplicationEntitiesOperation {
    public static final String NAME = "list replicas";
    static final String[] DESCRIPTOR_ELEMENTS = new String[]{"Replica Name", "Fully Qualified Source Name", "Fully Qualified Target Name", "Target Collection Name", "Event Scope", "Mode", "State", "Suspended", "MetaSchema"};

    public ListReplicasOperation() {
        super(NAME);
    }

    @Override
    String getEntityName() {
        return "replica";
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractNodeOperation.Definition definition = (AbstractNodeOperation.Definition)statement;
        RowSet result = new RowSet(ListReplicasOperation.createResultDescriptor());
        for (ReplicationTargetReference reference : this.getReplicationTargets(definition.getNodeName(), ListReplicasOperation.getEventScope(definition, session))) {
            int index = reference.getName().lastIndexOf(58);
            ReplicationSourceReference sourceReference = this.getReplicationSource(reference);
            boolean sourceEnabled = sourceReference == null || sourceReference.isEnabled();
            Object[] objectArray = new Object[9];
            objectArray[0] = reference.getName().substring(index + 1);
            objectArray[1] = reference.getSourceName();
            objectArray[2] = reference.getName();
            objectArray[3] = reference.getTargetCollectionName();
            objectArray[4] = reference.getEventScope();
            objectArray[5] = reference.getSync() != null ? (reference.getSync().booleanValue() ? "Sync" : "Async") : "n/a";
            objectArray[6] = reference.getState().getStateWithSourceDisabled(sourceEnabled);
            objectArray[7] = reference.isSuspended();
            objectArray[8] = reference.getMetaSchema().toString();
            result.addToRowSet(objectArray);
        }
        return new SLResponse(result);
    }

    ReplicationSourceReference getReplicationSource(ReplicationTargetReference targetReference) {
        return ((RuntimeContext)this.callable).getModerator().getReplicationSources(null).stream().filter(s -> s.getName().equals(targetReference.getSourceName())).findAny().orElse(null);
    }

    List<ReplicationTargetReference> getReplicationTargets(String nodeName, EventScope eventScope) throws FabricException {
        if (nodeName == null) {
            return ((RuntimeContext)this.callable).getModerator().getFabricNode().getReplicationTargets(eventScope);
        }
        if (nodeName.equalsIgnoreCase("*")) {
            return ((RuntimeContext)this.callable).getModerator().getReplicationTargets(eventScope);
        }
        return this.getNode(nodeName).getReplicationTargets(eventScope);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(11);
        for (String descriptorElement : DESCRIPTOR_ELEMENTS) {
            ListReplicasOperation.addColumn(result, descriptorElement);
        }
        return result;
    }

    @Override
    public AbstractNodeOperation.Definition createDefinition(String nodeName) {
        return new AbstractNodeOperation.Definition(NAME, nodeName);
    }
}

