/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.runtime.mf.operation.moderator.AbstractListEndpointsOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.Collections;
import java.util.List;

public class ListProducersOperation
extends AbstractListEndpointsOperation {
    public static final String NAME = "list producers";

    public ListProducersOperation() {
        super(NAME);
    }

    @Override
    String getEndpointName() {
        return "event producer";
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ListProducersOperation.createResultDescriptor());
        List<ComponentReference> components = this.getComponents(definition.eventScope);
        Collections.sort(components);
        for (ComponentReference component : components) {
            if (!component.hasBoundEventIds()) continue;
            if (definition.eventId != null) {
                if (!component.isBoundEventId(definition.eventId)) continue;
                ListProducersOperation.fillResult(component, definition, session, result);
                continue;
            }
            ListProducersOperation.fillResult(component, definition, session, result);
        }
        return new SLResponse(result);
    }

    private static void fillResult(ComponentReference component, Definition definition, MFSession session, RowSet result) throws Exception {
        List<String> nameTokens = ModeratorUtils.splitComponentFullName(component.getName());
        if (ListProducersOperation.isAll(definition.isAll(), session) || !ListProducersOperation.isSystemComponent(component.getModel(), nameTokens.get(2))) {
            result.addToRowSet(new Object[]{nameTokens.get(0), nameTokens.get(1), nameTokens.get(2), component.getModel().toString(), component.getEventScope(), ListProducersOperation.formatEventIds(component.listBoundEventIds())});
        }
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListProducersOperation.addColumn(result, "Node");
        ListProducersOperation.addColumn(result, "Type");
        ListProducersOperation.addColumn(result, "Name");
        ListProducersOperation.addColumn(result, "Model");
        ListProducersOperation.addColumn(result, "Scope");
        ListProducersOperation.addColumn(result, "Events");
        return result;
    }

    @Override
    Definition createDefinition(DSLStatement statement) throws ParsingException {
        return new Definition(this.syntax, statement);
    }

    public static class Definition
    extends AbstractListEndpointsOperation.Definition {
        private String eventId;

        Definition(DSLStatementSyntax syntax, DSLStatement statement) throws ParsingException {
            super(ListProducersOperation.NAME, syntax, statement);
            this.eventId = statement.existsParameter("EventId") ? statement.getParameter("EventId").getValue() : null;
        }

        public Definition(String eventId, String nodeName, EventScope eventScope, boolean isAll) {
            super(ListProducersOperation.NAME, nodeName, eventScope, isAll);
            this.eventId = eventId;
        }

        public String getEventId() {
            return this.eventId;
        }
    }
}

