/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.utils.NamedObjectComparator;
import com.streamscape.sef.dispatcher.AbstractModeratorOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ListNodesOperation
extends AbstractModeratorOperation {
    public static final String NAME = "list nodes";

    public ListNodesOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST NODES");
        this.syntax.setDescription("Shows a list of all nodes in the sysplex.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListNodesOperation.createResultDescriptor(((RuntimeContext)this.callable).isClustered()));
        ((RuntimeContext)this.callable).getModerator().getFabricNodes().stream().sorted(new NamedObjectComparator()).forEach(node -> {
            Object[] values;
            Object[] resultValues = values = new Object[]{node.getName(), node.getRole().toString(), node.getFabricAddress().toString(), node.getInetAddress() != null ? node.getInetAddress().toString() : "N/A", node.getProcessID() != -1 ? Integer.valueOf(node.getProcessID()) : "N/A", node.getVersion()};
            if (((RuntimeContext)this.callable).isClustered()) {
                resultValues = new Object[values.length + 1];
                System.arraycopy(values, 0, resultValues, 0, values.length);
                resultValues[values.length] = node.getClusterName();
            }
            ListNodesOperation.add(result, resultValues);
        });
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor(boolean addCluster) {
        RowMetaData result = new RowMetaData();
        ListNodesOperation.addColumn(result, "Node");
        ListNodesOperation.addColumn(result, "Role");
        ListNodesOperation.addColumn(result, "Address");
        ListNodesOperation.addColumn(result, "Host");
        ListNodesOperation.addColumn(result, "PID");
        ListNodesOperation.addColumn(result, "Release");
        if (addCluster) {
            ListNodesOperation.addColumn(result, "Cluster");
        }
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListNodesOperation.NAME);
        }
    }
}

