/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.EventScopeModifier;
import com.streamscape.runtime.mf.operation.moderator.AbstractListEndpointsOperation;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.ReservedNames;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EventIdParameter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ListEventFlowsOperation
extends AbstractNodeOperation {
    public static final String NAME = "list event flows";

    public ListEventFlowsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST EVENT FLOWS").addActionParameter(new EventIdParameter("EventId"));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.addModifier(new EventScopeModifier(false, EventScope.INHERITED));
        this.syntax.addModifier((AbstractModifier)new Modifier("ALL", false).setAlias("*"));
        String prefix = "  list event flows";
        this.syntax.setDescription("Returns a list of flows for the specified event.");
        this.syntax.setSyntaxDescription("Parameter EventId should be put in [] characters.\n\nOptional parameters:\n\n   at node     - Specifies the node.\n   at domain   - Specifies the whole sysplex.\n   event scope - Specifies the event scope (OBSERVABLE, GLOBAL, CLUSTER).\n   all         - Specifies if system event flows will be included in the result list.\n\nSupported operations:\n\n" + prefix + "                                        - List of non-system event flows with any event scope in the current node.\n" + prefix + " all                                    - List of all event flows with any event scope in the current node.\n" + prefix + " at node <NodeName>                     - List of non-system event flows with any event scope in the specified node.\n" + prefix + " at node <NodeName> all                 - List of all event flows with any event scope in the specified node.\n" + prefix + " at domain                              - List of non-system event flows with any event scope in the sysplex.\n" + prefix + " at domain all                          - List of all event flows with any event scope in the sysplex.\n" + prefix + " scope <Scope>                          - List of non-system event flows with the specified event scope in the current node.\n" + prefix + " scope <Scope> all                      - List of all event flows with the specified event scope in the current node.\n" + prefix + " at node <Node> event scope <Scope>     - List of non-system event flows with the specified event scope in the specified node.\n" + prefix + " at node <Node> event scope <Scope> all - List of all event flows with the specified event scope in the specified node.\n" + prefix + " at domain event scope <Scope>          - List of non-system event flows with the specified event scope in the sysplex.\n" + prefix + " at domain event scope <Scope> all      - List of all event flows with the specified event scope in the sysplex.");
        this.syntax.setExamples("list event flows [stock.tic.ibm]\nlist event flows [option.price] at node Pricer.US\nlist event flows [event.connection.fail] all\nlist event flows [event.portal.notify] at domain\nlist event flows [event.portal.notify] at domain event scope global all");
        this.syntax.addCompletionCommand("list event prototypes");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsParameter("EventId") ? statement.getParameter("EventId").getValue() : null, EventScopeModifier.getValue(this.syntax, statement), ListEventFlowsOperation.getNodeName(statement), statement.existsModifier("ALL"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ListEventFlowsOperation.createResultDescriptor());
        FabricNodeReference node = definition.nodeName != null && definition.nodeName.equals("*") ? null : this.getNode(definition.nodeName);
        List<ComponentReference> components = node != null ? node.getComponents(definition.eventScope) : ((RuntimeContext)this.callable).getModerator().getComponents(definition.eventScope);
        for (ComponentReference component : components) {
            if (!component.isBoundEventId(definition.eventId)) continue;
            List<String> nameTokens = ModeratorUtils.splitComponentFullName(component.getName());
            if (!ListEventFlowsOperation.isAll(definition.isAll(), session) && ListEventFlowsOperation.isSystemComponent(component.getModel(), nameTokens.get(2))) continue;
            result.addToRowSet(new Object[]{definition.eventId, "Producer", nameTokens.get(0), nameTokens.get(1), nameTokens.get(2), component.getModel(), "", "", component.getEventScope()});
        }
        List<EventConsumerReference> consumers = node != null ? node.getEventConsumers(definition.eventScope) : ((RuntimeContext)this.callable).getModerator().getEventConsumers(definition.eventScope);
        for (EventConsumerReference consumer : consumers) {
            if (!consumer.matchesEventId(definition.eventId)) continue;
            List<String> nameTokens = ModeratorUtils.splitConsumerFullName(consumer.getName());
            if (!ListEventFlowsOperation.isAll(definition.isAll(), session) && (AbstractListEndpointsOperation.isSystemComponent(nameTokens.get(1), nameTokens.get(2)) || ReservedNames.isReserved(nameTokens.get(3)))) continue;
            ComponentReference component = ((RuntimeContext)this.callable).getModerator().lookupComponent(consumer.getComponentAddress());
            result.addToRowSet(new Object[]{consumer.getEventFilter(), "Consumer", nameTokens.get(0), nameTokens.get(1), nameTokens.get(2), component.getModel(), nameTokens.get(3), ModeratorUtils.getConsumerMode(consumer.getExchangeRole()), consumer.getEventScope()});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        for (String elem : Arrays.asList("Event", "Role", "Node", "Component Type", "Component Name", "Component Model", "Consumer Name", "Consumer Mode", "Event Scope")) {
            ListEventFlowsOperation.addColumn(result, elem);
        }
        return result;
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getDatagramPrototypeCache().listEventIds().stream().map(eventId -> "[" + eventId + "]").collect(Collectors.toList()));
    }

    public static class Definition
    extends AbstractNodeOperation.Definition {
        private String eventId;
        private EventScope eventScope;
        private boolean isAll;

        public Definition(String eventId, EventScope eventScope, String nodeName, boolean isAll) {
            super(ListEventFlowsOperation.NAME, nodeName);
            this.eventId = eventId;
            this.eventScope = eventScope;
            this.isAll = isAll;
        }

        public String getEventId() {
            return this.eventId;
        }

        public EventScope getEventScope() {
            return this.eventScope;
        }

        public boolean isAll() {
            return this.isAll;
        }
    }
}

