/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.moderator;

import com.streamscape.lib.dispatcher.ConsumerState;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.moderator.AbstractListEndpointsOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.ConsumerReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListConsumersOperation
extends AbstractListEndpointsOperation {
    public static final String NAME = "list consumers";
    private static final String[] DESCRIPTOR_ELEMENTS = new String[]{"Node", "Component Type", "Component Name", "Consumer Name", "Mode", "Scope", "Event", "State", "Time"};

    public ListConsumersOperation() {
        super(NAME);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.session);
    }

    @Override
    String getEndpointName() {
        return "consumer";
    }

    @Override
    void setAction(String name) {
        this.syntax.setAction("LIST CONSUMERS").addModifier((AbstractModifier)new Modifier("REQUEST", false).setSyntaxHintSpace());
    }

    @Override
    void setCompactSyntax() {
        this.syntax.setCompactSyntax("list consumers [request] [for <EventId>]\n   [{at | @} {node <NodeName> | domain}]\n   [event scope {observable | global | cluster}]\n   [all | *]\nlist consumers console\n");
    }

    @Override
    String getMainDescription(String name, String endpointsName) {
        return "list consumers         - Returns a list of non-system consumers in the current node.\nlist consumers request - Returns a list of non-system request consumers in the current node.\nlist consumers console - Returns a list of all special consumers in the SLANG tool console.\n";
    }

    @Override
    String getSpecificExamples() {
        return "\nlist consumers request\nlist consumers request all\nlist consumers request at node Sample2\nlist consumers request at domain all\nlist consumers console";
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ListConsumersOperation.createResultDescriptor());
        ListConsumersOperation.addConsumers(this.getConsumers(definition.isRequest, definition.eventScope), definition, session, ((RuntimeContext)this.callable).getModerator(), result);
        return new SLResponse(result);
    }

    private List<? extends ConsumerReference> getConsumers(boolean isRequest, EventScope eventScope) throws FabricException {
        return isRequest ? ((RuntimeContext)this.callable).getModerator().getFabricNode().getRequestConsumers(eventScope) : ((RuntimeContext)this.callable).getModerator().getFabricNode().getConsumers(eventScope);
    }

    public static <T extends ConsumerReference> void addConsumers(List<T> consumers, Definition definition, MFSession session, Moderator moderator, RowSet result) throws Exception {
        Collections.sort(consumers);
        for (ConsumerReference consumer : consumers) {
            if (definition != null && !definition.isRequest && definition.eventId != null) {
                if (!(consumer instanceof EventConsumerReference) || !((EventConsumerReference)consumer).matchesEventId(definition.eventId)) continue;
                ListConsumersOperation.fillResult(consumer, definition, session, moderator, result);
                continue;
            }
            ListConsumersOperation.fillResult(consumer, definition, session, moderator, result);
        }
    }

    private static void fillResult(ConsumerReference consumer, Definition definition, MFSession session, Moderator moderator, RowSet result) throws Exception {
        ListConsumersOperation.fillResult(consumer, definition != null && definition.isAll(), session, moderator, result);
    }

    private static void fillResult(ConsumerReference consumer, boolean isAll, MFSession session, Moderator moderator, RowSet result) throws Exception {
        List<String> nameTokens = ModeratorUtils.splitConsumerFullName(consumer.getName());
        if ((ListConsumersOperation.isAll(isAll, session) || !ListConsumersOperation.isSystemConsumer(nameTokens.get(1), nameTokens.get(2), nameTokens.get(3))) && ListConsumersOperation.checkSysadmin(consumer, moderator, session)) {
            ArrayList<String> row = new ArrayList<String>(result.getRowMetaData().getColumnCount());
            Collections.addAll(row, nameTokens.get(0), nameTokens.get(1), nameTokens.get(2), nameTokens.get(3), ModeratorUtils.getConsumerMode(consumer.getExchangeRole()), consumer.getEventScope().name());
            if (consumer instanceof EventConsumerReference) {
                EventConsumerReference eventConsumer = (EventConsumerReference)consumer;
                row.add(String.valueOf(ListConsumersOperation.getEventIds(eventConsumer)) + (String)(eventConsumer.getEventSelector() != null ? " when (" + eventConsumer.getEventSelector() + ")" : ""));
            } else if (consumer instanceof RequestConsumerReference) {
                row.add(StringUtils.wrapEventId("#"));
            }
            ConsumerState state = consumer.getCurrentState();
            if (state != null) {
                row.add(state.getWorkingState().toString());
                if (state.getWorkingState() == ConsumerState.WorkingState.BUSY) {
                    row.add(Long.toString(System.currentTimeMillis() - state.getStartTime()));
                }
            }
            ListConsumersOperation.addEmptyElements(row, DESCRIPTOR_ELEMENTS.length);
            result.addToRowSet(row.toArray());
        }
    }

    static boolean checkSysadmin(ConsumerReference consumer, Moderator moderator, MFSession session) {
        ComponentReference component = moderator.lookupComponent(consumer.getComponentAddress());
        return component == null || ListConsumersOperation.checkSysadmin(session, component);
    }

    public static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        for (String descriptorElement : DESCRIPTOR_ELEMENTS) {
            ListConsumersOperation.addColumn(result, descriptorElement);
        }
        return result;
    }

    private static void addEmptyElements(List<String> row, int size) {
        int difference = size - row.size();
        for (int i = 0; i < difference; ++i) {
            row.add("");
        }
    }

    @Override
    Definition createDefinition(DSLStatement statement) throws ParsingException {
        return new Definition(this.syntax, statement);
    }

    public static class Definition
    extends AbstractListEndpointsOperation.Definition {
        private boolean isRequest;
        private String eventId;

        Definition(DSLStatementSyntax syntax, DSLStatement statement) throws ParsingException {
            super(ListConsumersOperation.NAME, syntax, statement);
            this.isRequest = statement.existsModifier("REQUEST");
            this.eventId = statement.existsParameter("EventId") ? statement.getParameter("EventId").getValue() : null;
        }

        public Definition(boolean isRequest, String eventId, String nodeName, EventScope eventScope, boolean isAll) {
            super(ListConsumersOperation.NAME, nodeName, eventScope, isAll);
            this.isRequest = isRequest;
            this.eventId = eventId;
        }

        public boolean isRequest() {
            return this.isRequest;
        }

        public String getEventId() {
            return this.eventId;
        }
    }
}

